/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.transformation.emf.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.transformation.context.GenericTransformationContext;
import org.polarsys.kitalpha.transposer.transformation.emf.resource.ResourceUtil;
import org.polarsys.kitalpha.transposer.transformation.emf.traces.Trace;
import org.polarsys.kitalpha.transposer.transformation.emf.traces.TraceRepository;
import org.polarsys.kitalpha.transposer.transformation.emf.traces.TracesFactory;
import org.polarsys.kitalpha.transposer.transformation.trace.TraceHelper;

public class TraceLoader
implements IActivity,
ITransposerWorkflow {
    public static final String ID = "org.polarsys.kitalpha.transposer.transformation.emf.trace.load";
    public static final String TRANSPOSER_TRACE_MODEL = "TraceModelPath";
    public static final String TRANSPOSER_TRACE_REPOSITORY = "TraceModelRepository";
    private DeclaredParameter _traceModelPath = new DeclaredParameter("TraceModelPath", "", "Path of the trace model to load");

    public Collection<DeclaredParameter> getParameters() {
        ArrayList<DeclaredParameter> declaredParameter = new ArrayList<DeclaredParameter>();
        declaredParameter.add(this._traceModelPath);
        return declaredParameter;
    }

    public IStatus run(ActivityParameters activityParams_p) {
        Resource res;
        String traceModelPath = null;
        TraceRepository tracesRepo = null;
        IStatus status = Status.OK_STATUS;
        IContext context = (IContext)activityParams_p.getParameter("TransposerContext").getValue();
        Object tracePath = activityParams_p.getParameter(TRANSPOSER_TRACE_MODEL).getValue();
        if (context == null) {
            return new Status(4, "org.polarsys.kitalpha.transposer.transformation.emf", "Context in not initialized in the Transposer Workflow");
        }
        if (tracePath == null || tracePath.equals("")) {
            return new Status(4, "org.polarsys.kitalpha.transposer.transformation.emf", "Trace Model Path is not defined, please check the parameter of this activity");
        }
        if (tracePath instanceof String) {
            traceModelPath = (String)tracePath;
        }
        if (context.exists((Object)TRANSPOSER_TRACE_MODEL)) {
            String path = (String)context.get((Object)TRANSPOSER_TRACE_MODEL);
            traceModelPath = "".equals(path) ? traceModelPath : path;
        }
        ResourceSetImpl rs = null;
        if (context.get((Object)"TransposerResourceSet") != null) {
            Object set = context.get((Object)"TransposerResourceSet");
            if (set instanceof ResourceSet) {
                rs = (ResourceSet)set;
            }
        } else {
            rs = new ResourceSetImpl();
            context.put((Object)"TransposerResourceSet", (Object)rs);
        }
        EcoreUtil.resolveAll((ResourceSet)rs);
        if (this.isExistingTracePath(traceModelPath) && rs != null && context instanceof GenericTransformationContext) {
            EObject tr;
            Collection<EObject> traces = this.loadTraceModel((ResourceSet)rs, traceModelPath);
            if (traces != null && !traces.isEmpty() && (tr = traces.iterator().next()) instanceof TraceRepository) {
                tracesRepo = (TraceRepository)tr;
            }
        } else {
            res = rs.createResource(URI.createURI((String)traceModelPath));
            tracesRepo = TracesFactory.eINSTANCE.createTraceRepository();
            res.getContents().add((Object)tracesRepo);
        }
        if (tracesRepo != null) {
            this.initializeContext((GenericTransformationContext)context, tracesRepo);
            context.put((Object)TRANSPOSER_TRACE_REPOSITORY, (Object)tracesRepo);
            res = tracesRepo.eResource();
            res.setTrackingModification(true);
        }
        return status;
    }

    private void initializeContext(GenericTransformationContext context_p, TraceRepository tr_p) {
        TraceHelper helper = context_p.getTraceHelper();
        if (helper != null) {
            for (Trace trace : tr_p.getTraces()) {
                EObject source = null;
                EObject target = null;
                if (!trace.getSource().eIsProxy()) {
                    source = trace.getSource();
                }
                if (!trace.getTarget().eIsProxy()) {
                    target = trace.getTarget();
                }
                helper.addTraceWithRole((Object)source, (Object)target, trace.getRole());
            }
        }
    }

    private Collection<EObject> loadTraceModel(ResourceSet rs_p, String traceModelPath_p) {
        return ResourceUtil.loadURI(traceModelPath_p, rs_p);
    }

    private boolean isExistingTracePath(String traceModelPath_p) {
        if (traceModelPath_p != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(traceModelPath_p));
            return file.exists();
        }
        return false;
    }

    public Map<String, ParameterError<?>> validateParameters(ActivityParameters valuedParameters_p) {
        return null;
    }
}

