/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.sirius.rotativeimage.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.WorkspaceImageEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.figure.IWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.ext.draw2d.figure.ITransparentFigure;
import org.polarsys.kitalpha.sirius.rotativeimage.Activator;
import org.polarsys.kitalpha.sirius.rotativeimage.extension.RotativeDescription;
import org.polarsys.kitalpha.sirius.rotativeimage.figures.Rotative4ImagesSVGWorkspaceImageFigure;
import org.polarsys.kitalpha.sirius.rotativeimage.figures.RotativeSVGWorkspaceImageFigure;
import org.polarsys.kitalpha.sirius.rotativeimage.figures.RotativeWorkspaceImageFigure;
import org.polarsys.kitalpha.sirius.rotativeimage.internal.helpers.RotativeWorkspaceImageHelper;
import org.polarsys.kitalpha.sirius.rotativeimage.internal.messages.Messages;

public class RotativeImageEditPart
extends WorkspaceImageEditPart
implements IStyleEditPart {
    public RotativeImageEditPart(View view) {
        super(view);
    }

    protected IFigure createNodeShape() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof WorkspaceImage) {
            WorkspaceImage wkImage = (WorkspaceImage)element;
            String workspacePath = wkImage.getWorkspacePath();
            RotativeDescription desc = Activator.getDefault().getBestDescription(workspacePath);
            if (desc == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.rotativeImageEditPartErrorCreateNodeShapeNullDescription, (Object)workspacePath));
            }
            this.primaryShape = this.getWorkspaceImageFigure(wkImage, workspacePath, desc);
            SwitchImageListener switchImageListener = new SwitchImageListener(this);
            this.primaryShape.addFigureListener((FigureListener)switchImageListener);
            this.primaryShape.addPropertyChangeListener((PropertyChangeListener)switchImageListener);
            EditPart parent = this.getParent();
            if (parent instanceof IDiagramBorderNodeEditPart && this.primaryShape instanceof ITransparentFigure) {
                DiagramBorderNodeEditPartOperation.updateTransparencyMode((IDiagramBorderNodeEditPart)((IDiagramBorderNodeEditPart)parent), (ITransparentFigure)((ITransparentFigure)this.primaryShape));
            }
        }
        return this.primaryShape;
    }

    private IWorkspaceImageFigure getWorkspaceImageFigure(WorkspaceImage workspaceImage, String workspacePath, RotativeDescription description) {
        Object figure;
        if (description.mode == 1) {
            figure = WorkspaceImageFigure.isSvgImage((String)workspacePath) ? RotativeSVGWorkspaceImageFigure.createImageFigure(workspaceImage) : new RotativeWorkspaceImageFigure(workspacePath);
        } else if (WorkspaceImageFigure.isSvgImage((String)description.id)) {
            figure = Rotative4ImagesSVGWorkspaceImageFigure.createImageFigure(workspaceImage, workspacePath);
        } else {
            RotativeWorkspaceImageHelper.createImage(description.id, 1);
            RotativeWorkspaceImageHelper.createImage(description.id, 8);
            RotativeWorkspaceImageHelper.createImage(description.id, 4);
            RotativeWorkspaceImageHelper.createImage(description.id, 16);
            figure = new RotativeWorkspaceImageFigure(description.id);
        }
        return figure;
    }

    private static class SwitchImageListener
    implements PropertyChangeListener,
    FigureListener {
        private RotativeImageEditPart editPart;

        public SwitchImageListener(RotativeImageEditPart editPart) {
            this.editPart = editPart;
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            this.updateImage();
        }

        public void figureMoved(IFigure source) {
            this.updateImage();
        }

        public void updateImage() {
            if (this.editPart.figure == null || this.editPart.getPrimaryShape() == null) {
                return;
            }
            org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator borderItemLocator = this.getBorderItemLocator();
            if (borderItemLocator != null) {
                BorderedNodeFigure borderedNodeFigure = this.getBorderedNodeFigure();
                if (borderedNodeFigure == null) {
                    return;
                }
                Rectangle parentBounds = borderedNodeFigure.getBounds();
                if (parentBounds.height != 0 && parentBounds.width != 0) {
                    int side = DBorderItemLocator.findClosestSideOfParent((Rectangle)this.editPart.getFigure().getBounds(), (Rectangle)borderedNodeFigure.getBounds());
                    IWorkspaceImageFigure figure = this.editPart.getPrimaryShape();
                    if (figure instanceof RotativeSVGWorkspaceImageFigure) {
                        ((RotativeSVGWorkspaceImageFigure)figure).setOrientation(side);
                    } else if (figure instanceof Rotative4ImagesSVGWorkspaceImageFigure) {
                        ((Rotative4ImagesSVGWorkspaceImageFigure)figure).setOrientation(side);
                    } else {
                        ((RotativeWorkspaceImageFigure)figure).setOrientation(side);
                    }
                }
            }
        }

        private BorderedNodeFigure getBorderedNodeFigure() {
            boolean first = false;
            BorderedNodeFigure borderedNodeFigure = null;
            RotativeImageEditPart current = this.editPart;
            IBorderedShapeEditPart borderNodeEditPart = null;
            while (current != null && borderNodeEditPart == null) {
                if (current instanceof IBorderedShapeEditPart) {
                    if (first) {
                        borderNodeEditPart = (IBorderedShapeEditPart)current;
                    } else {
                        first = true;
                    }
                }
                current = (IGraphicalEditPart)current.getParent();
            }
            borderedNodeFigure = borderNodeEditPart != null ? borderNodeEditPart.getBorderedFigure() : null;
            return borderedNodeFigure;
        }

        private org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator getBorderItemLocator() {
            IBorderItemLocator borderItemLocator = null;
            RotativeImageEditPart current = this.editPart;
            IDiagramBorderNodeEditPart borderNodeEditPart = null;
            while (current != null && borderNodeEditPart == null) {
                if (current instanceof IDiagramBorderNodeEditPart) {
                    borderNodeEditPart = (IDiagramBorderNodeEditPart)current;
                }
                current = (IGraphicalEditPart)current.getParent();
            }
            if (borderNodeEditPart instanceof IBorderItemEditPart) {
                borderItemLocator = ((IBorderItemEditPart)borderNodeEditPart).getBorderItemLocator();
            }
            return borderItemLocator;
        }
    }
}

