/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.validation.internal.configurer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.kitalpha.validation.configurer.ConfigurerException;
import org.polarsys.kitalpha.validation.configurer.IConstraintConfigurer;
import org.polarsys.kitalpha.validation.provider.generic.IAccuracyConstraintDescriptor;
import org.polarsys.kitalpha.validation.util.TypeUtils;

public class ConstraintConfigurer
implements IConstraintConfigurer {
    private static final String RULES_LIST = "additional.rules.list";
    private static final String CATEGORY = "category";
    private Map<String, Set<IAccuracyConstraintDescriptor>> requirementIdToConstraints;

    @Override
    public void configure(Properties properties) throws ConfigurerException {
        Category category = this.getCategory(properties);
        this.deactivateCategory(category);
        List<IConstraintDescriptor> descriptors = this.getDescriptors(properties);
        this.activateConstraints(descriptors);
    }

    private void activateConstraints(List<IConstraintDescriptor> descriptors) {
        for (IConstraintDescriptor descriptor : descriptors) {
            EMFModelValidationPreferences.setConstraintDisabled((String)descriptor.getId(), (boolean)false);
        }
    }

    private List<IConstraintDescriptor> getDescriptors(Properties properties) throws ConfigurerException {
        String additionalRules = properties.getProperty(RULES_LIST);
        if (additionalRules == null) {
            throw new ConfigurerException("No additional rules found in the properties (missing key: 'additional.rules.list')");
        }
        String[] splittedRules = additionalRules.split(Pattern.quote(","));
        int i = 0;
        while (i < splittedRules.length) {
            splittedRules[i] = splittedRules[i].trim();
            ++i;
        }
        ArrayList<IConstraintDescriptor> result = new ArrayList<IConstraintDescriptor>(splittedRules.length);
        String[] stringArray = splittedRules;
        int n = splittedRules.length;
        int n2 = 0;
        while (n2 < n) {
            String ruleId = stringArray[n2];
            Set<IAccuracyConstraintDescriptor> descriptors = this.getRequirementIdToConstraints().get(ruleId);
            if (descriptors == null) {
                throw new ConfigurerException("No constraints found for rule id: " + ruleId);
            }
            result.addAll(descriptors);
            ++n2;
        }
        return result;
    }

    private void deactivateCategory(Category category) {
        for (IConstraintDescriptor constraintDescriptor : TypeUtils.cast(category.getConstraints(), IConstraintDescriptor.class)) {
            if (ConstraintConfigurer.isMandatory(constraintDescriptor)) continue;
            EMFModelValidationPreferences.setConstraintDisabled((String)constraintDescriptor.getId(), (boolean)true);
        }
        for (Category cat : TypeUtils.cast(category.getChildren(), Category.class)) {
            this.deactivateCategory(cat);
        }
    }

    private Category getCategory(Properties properties) throws ConfigurerException {
        String categoryName = properties.getProperty(CATEGORY);
        if (categoryName == null) {
            throw new ConfigurerException("No additional rules found in the properties (missing key: 'additional.rules.list')");
        }
        Category category = CategoryManager.getInstance().getCategory(categoryName);
        return category;
    }

    private Map<String, Set<IAccuracyConstraintDescriptor>> getRequirementIdToConstraints() {
        if (this.requirementIdToConstraints == null) {
            this.requirementIdToConstraints = new HashMap<String, Set<IAccuracyConstraintDescriptor>>();
            for (Object descriptor : ConstraintRegistry.getInstance().getAllDescriptors()) {
                if (!(descriptor instanceof IAccuracyConstraintDescriptor)) continue;
                IAccuracyConstraintDescriptor constraintDescriptor = (IAccuracyConstraintDescriptor)descriptor;
                String requirementId = constraintDescriptor.getRequirementId();
                Set<IAccuracyConstraintDescriptor> descriptors = this.requirementIdToConstraints.get(requirementId);
                if (descriptors == null) {
                    descriptors = new HashSet<IAccuracyConstraintDescriptor>();
                    this.requirementIdToConstraints.put(requirementId, descriptors);
                }
                descriptors.add(constraintDescriptor);
            }
        }
        return this.requirementIdToConstraints;
    }

    private static boolean isMandatory(IConstraintDescriptor descriptor) {
        boolean result = false;
        Iterator<Category> iter = TypeUtils.cast(descriptor.getCategories(), Category.class).iterator();
        while (!result && iter.hasNext()) {
            result = iter.next().isMandatory();
        }
        return result;
    }
}

