/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.visualize.helpers;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.visualize.column.QueryColumn;
import org.polarsys.kitalpha.massactions.visualize.helpers.container.UnfoldedRowObject;

public class UnfoldRowObjectHelper {
    private static final Log log = LogFactory.getLog(UnfoldRowObjectHelper.class);
    public static final Integer NULL_VALUE_INDEX = -1;
    public static final Integer EMPTY_COLLECTION_VALUE_INDEX = -2;
    public static final Integer NOT_A_COLLECTION_VALUE_INDEX = -3;
    public static final Integer HIDDEN_COLUMN_VALUE_INDEX = -4;
    public static final Integer QUERY_COLUMN_VALUE_INDEX = -5;

    private UnfoldRowObjectHelper() {
    }

    public static List<Set<Integer>> extractRowObjectColumnIndexes(EObject rowObject, List<IMAColumn> columns, Set<Integer> hiddenColumnIndexes) {
        ArrayList<Set<Integer>> rowObjectColumnIndexes = new ArrayList<Set<Integer>>();
        for (IMAColumn column : columns) {
            Set<Integer> columnIndexes = new HashSet<Integer>();
            if (hiddenColumnIndexes.contains(column.getIndex())) {
                columnIndexes.add(HIDDEN_COLUMN_VALUE_INDEX);
            } else if (column instanceof QueryColumn) {
                columnIndexes.add(QUERY_COLUMN_VALUE_INDEX);
            } else {
                Object dataValue = column.getDataValue(rowObject);
                if (dataValue == null) {
                    columnIndexes.add(NULL_VALUE_INDEX);
                } else if (dataValue instanceof Collection) {
                    Collection dataValues = (Collection)dataValue;
                    if (dataValues.isEmpty()) {
                        columnIndexes.add(EMPTY_COLLECTION_VALUE_INDEX);
                    } else {
                        columnIndexes = IntStream.range(0, dataValues.size()).boxed().collect(Collectors.toSet());
                    }
                } else {
                    columnIndexes.add(NOT_A_COLLECTION_VALUE_INDEX);
                }
            }
            rowObjectColumnIndexes.add(columnIndexes);
        }
        return rowObjectColumnIndexes;
    }

    public static Set<EObject> createUnfoldedObjects(EObject rowObject, List<IMAColumn> columns, Set<Integer> hiddenColumnIndexes) {
        List<Set<Integer>> rowObjectColumnIndexes = UnfoldRowObjectHelper.extractRowObjectColumnIndexes(rowObject, columns, hiddenColumnIndexes);
        Set columnIndexCartesianProduct = Sets.cartesianProduct(rowObjectColumnIndexes);
        log.info((Object)("Cartesian product of size [" + columnIndexCartesianProduct.size() + "] for " + rowObject));
        return columnIndexCartesianProduct.stream().map(indexes -> new UnfoldedRowObject(rowObject, columns, (List<Integer>)indexes)).collect(Collectors.toSet());
    }

    public static Collection<EObject> createUnfoldedObjects(Collection<EObject> rowObjects, List<IMAColumn> columns, Set<Integer> hiddenColumnIndexes) {
        return rowObjects.stream().flatMap(rowObject -> UnfoldRowObjectHelper.createUnfoldedObjects(rowObject, columns, hiddenColumnIndexes).stream()).collect(Collectors.toList());
    }
}

