/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.util;

import java.util.MissingResourceException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

public class EObjectLabelProviderHelper {
    public static final String EMPTY_STRING = "";
    public static final char UNDERSCORE_CHARACTER = '_';
    private static final String FEATURE_GENERATED_KEY_SUFFIX = "_feature";
    private static final String METACLASS_GENERATED_KEY_SUFFIX = "_type";
    private static final String GENERATED_KEY_PREFIX = "_UI_";
    private static final String METACLASS_DISPLAY_PREFIX = "[";
    private static final String METACLASS_DISPLAY_SUFFIX = "] ";

    private EObjectLabelProviderHelper() {
    }

    public static String getText(EObject object) {
        String label = EMPTY_STRING;
        if (object == null) {
            return label;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        if (editingDomain == null) {
            return label;
        }
        IItemLabelProvider provider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
        if (provider != null) {
            label = provider.getText((Object)object);
        }
        return label;
    }

    public static Image getImage(EObject object) {
        Object image = null;
        if (object == null) {
            return null;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        if (editingDomain == null) {
            return null;
        }
        IItemLabelProvider provider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
        if (provider != null) {
            image = provider.getImage((Object)object);
        }
        return image != null ? EObjectLabelProviderHelper.getImageFromObject(image) : null;
    }

    public static Image getImageFromObject(Object image) {
        return ExtendedImageRegistry.getInstance().getImage(image);
    }

    public static String getMetaclassLabel(EObject object, boolean addBrackets) {
        String label = null;
        if (object == null) {
            return label;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        if (editingDomain == null) {
            return label;
        }
        IItemLabelProvider provider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
        if (provider instanceof ItemProviderAdapter) {
            label = EObjectLabelProviderHelper.getMetaclassLabel(object.eClass(), (ItemProviderAdapter)provider);
        }
        if (addBrackets) {
            label = METACLASS_DISPLAY_PREFIX + label + METACLASS_DISPLAY_SUFFIX;
        }
        return label;
    }

    public static String getMetaclassLabel(EClass eClass, ItemProviderAdapter provider) {
        String label = null;
        if (eClass == null || provider == null) {
            return label;
        }
        try {
            label = provider.getString(GENERATED_KEY_PREFIX + eClass.getName() + METACLASS_GENERATED_KEY_SUFFIX);
        }
        catch (MissingResourceException missingResourceException) {
            label = "<<MissingResourceException>> [" + eClass.getName() + "]";
        }
        return label;
    }

    public static String getFeatureLabel(EStructuralFeature feature, ItemProviderAdapter provider) {
        String label = null;
        if (feature == null || provider == null) {
            return label;
        }
        String featureKey = String.valueOf(feature.getEContainingClass().getName()) + '_' + feature.getName();
        label = provider.getString(GENERATED_KEY_PREFIX + featureKey + FEATURE_GENERATED_KEY_SUFFIX);
        return label;
    }
}

