/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.persistence;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.persistence.PersistenceHelper;

public class MAProperties
extends Properties {
    private static final Log log = LogFactory.getLog(MAProperties.class);
    private static final long serialVersionUID = -6579028390851088684L;
    private static final String DEFAULT_FILE_PATH = "props/massEdition.properties";
    public static final String PERSISTENCE_KEY_VALID_CLASSES = ".validClasses";

    public void save(String filePath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream tableStateStream = new FileOutputStream(filePath, false);){
                this.store(tableStateStream, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void save() {
        this.save(DEFAULT_FILE_PATH);
    }

    public void load(String filePath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream tableStateStream = new FileInputStream(filePath);){
                this.load(tableStateStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error((Object)"No configuration file found.");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void load() {
        this.load(DEFAULT_FILE_PATH);
    }

    public MAProperties copy() {
        MAProperties copy = new MAProperties();
        copy.putAll((Map<?, ?>)this);
        return copy;
    }

    public Object setCurentValidClasses(Set<String> classes) {
        String activeConfiguration = this.getProperty("PersistenceDialog.activeViewConfiguration");
        String key = String.valueOf(activeConfiguration) + PERSISTENCE_KEY_VALID_CLASSES;
        String value = String.join((CharSequence)",", classes);
        return this.setProperty(key, value);
    }

    private Set<String> getValidClasses(String state) {
        String key = String.valueOf(state) + PERSISTENCE_KEY_VALID_CLASSES;
        String value = this.getProperty(key);
        if (value == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(value.split(",")));
    }

    public MAProperties getValidProperties(Set<String> validClasses) {
        MAProperties validProperties = this.copy();
        Collection availableStates = PersistenceHelper.getAvailableStates((Properties)validProperties);
        for (String state : availableStates) {
            Set<String> stateClasses = this.getValidClasses(state);
            if (stateClasses.equals(validClasses)) continue;
            PersistenceHelper.deleteState((String)state, (Properties)validProperties);
        }
        return validProperties;
    }
}

