/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.sirius.util.diagram;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class DiagramExportRegistry {
    private static DiagramExportRegistry INSTANCE;
    private Map<String, DiagramExportRegistryObject> mapDiagramToExportObject = new HashMap<String, DiagramExportRegistryObject>();

    private DiagramExportRegistry() {
    }

    public static DiagramExportRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DiagramExportRegistry();
        }
        return INSTANCE;
    }

    public void addEntry(DDiagram diagram, IFile file, DRepresentationDescriptor descriptor, String mapName, String diagramName) {
        DiagramExportRegistryObject obj = new DiagramExportRegistryObject(file, descriptor, mapName, diagramName);
        DiagramExportRegistry.getInstance().mapDiagramToExportObject.put(diagram.getUid(), obj);
    }

    public DiagramExportRegistryObject getDiagramRelatedRegistryObject(DDiagram diagram) {
        return DiagramExportRegistry.getInstance().mapDiagramToExportObject.get(diagram.getUid());
    }

    public Boolean hasDataForDiagram(DDiagram diagram) {
        return DiagramExportRegistry.getInstance().mapDiagramToExportObject.containsKey(diagram.getUid());
    }

    public void clean() {
        DiagramExportRegistry.getInstance().mapDiagramToExportObject.clear();
    }

    public class DiagramExportRegistryObject {
        private IFile file;
        private DRepresentationDescriptor descriptor;
        private String mapName;
        private String diagramName;

        public DiagramExportRegistryObject(IFile file, DRepresentationDescriptor descriptor, String mapName, String diagramName) {
            this.file = file;
            this.descriptor = descriptor;
            this.mapName = mapName;
            this.diagramName = diagramName;
        }

        public IFile getFile() {
            return this.file;
        }

        public DRepresentationDescriptor getRepresentationDescriptor() {
            return this.descriptor;
        }

        public String getMapName() {
            return this.mapName;
        }

        public String getDiagramName() {
            return this.diagramName;
        }
    }
}

