/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.predicate.internal.engine.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.polarsys.kitalpha.ad.viewpoint.predicate.exceptions.EvaluationException;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Action;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Context;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.ContextProvider;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Predicate;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Transition;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.TransitionEngine;

public class TransitionEngineImpl
implements TransitionEngine {
    private final Transition transition;
    private final Context context;
    private final Map<String, Boolean> predicatesStates;
    private static final BinaryOperator<Boolean> and = (left, right) -> left != false && right != false;

    public TransitionEngineImpl(Transition transition, ContextProvider context) {
        this.transition = transition;
        this.context = context.getContext();
        this.predicatesStates = new HashMap<String, Boolean>();
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public boolean eval() throws EvaluationException {
        try {
            this.initializeStates();
            Collection<Boolean> evalPredicates = this.predicatesStates.values();
            return evalPredicates.stream().reduce(true, and);
        }
        catch (Exception cause) {
            throw new EvaluationException("An exception is thown while the evaluation of the predicates. See the exception stack for more information", cause);
        }
    }

    @Override
    public boolean run() throws EvaluationException {
        try {
            boolean result = this.eval();
            if (result) {
                Action action = this.getTransition().getAction();
                action.run(this.context);
            }
            return result;
        }
        catch (Exception cause) {
            throw new EvaluationException("An exception is thown while the execution of the action: " + this.getTransition().getActionID() + ". See the exception stack for more information", cause);
        }
    }

    private void initializeStates() {
        Map<String, Predicate> predicates = this.getTransition().getPredicates();
        for (Map.Entry<String, Predicate> e : predicates.entrySet()) {
            this.predicatesStates.put(e.getKey(), e.getValue().apply(this.context));
        }
    }

    @Override
    public Map<String, String> getDiagnosticMessages(boolean predicateValue) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Boolean> e : this.predicatesStates.entrySet()) {
            if (e.getValue() != predicateValue) continue;
            String diagnosticMessage = this.getTransition().getDiagnosticMessage(e.getKey());
            result.put(e.getKey(), diagnosticMessage);
        }
        return result;
    }
}

