/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.emfvalidation.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.util.TextUtils;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class ValidationContext
implements IValidationContext {
    private EObject target;
    private IModelConstraint currentConstraint = null;
    private final Set<EObject> resultLocus = new HashSet<EObject>();
    private final Map<IModelConstraint, Object> constraintData = new HashMap<IModelConstraint, Object>();

    public void addResult(EObject eObject) {
        assert (eObject != null);
        this.resultLocus.add(eObject);
    }

    public void addResults(Collection<? extends EObject> eObjects) {
        assert (eObjects != null);
        for (EObject eObject : eObjects) {
            this.addResult(eObject);
        }
    }

    public IStatus createFailureStatus(Object ... messageArgs) {
        String message = TextUtils.formatMessage((String)this.getDescriptor().getMessagePattern(), (Object[])(messageArgs == null ? new Object[]{} : messageArgs));
        if (Trace.shouldTrace((String)EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION)) {
            Trace.trace((String)EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION, (String)("Constraint " + this.getCurrentConstraintId() + " failed: " + message));
        }
        return new ConstraintStatus(this.getConstraint(), this.getTarget(), message, this.getResultLocus());
    }

    public IStatus createSuccessStatus() {
        if (Trace.shouldTrace((String)EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION)) {
            Trace.trace((String)EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION, (String)("Constraint " + this.getCurrentConstraintId() + " passed."));
        }
        return Status.OK_STATUS;
    }

    public void disableCurrentConstraint(Throwable exception) {
        this.getDescriptor().setError(exception);
    }

    public List<Notification> getAllEvents() {
        return Collections.emptyList();
    }

    public Object getCurrentConstraintData() {
        return this.constraintData.get(this.getConstraint());
    }

    public String getCurrentConstraintId() {
        return this.getConstraint().getDescriptor().getId();
    }

    public EMFEventType getEventType() {
        return EMFEventType.NULL;
    }

    public EStructuralFeature getFeature() {
        return null;
    }

    public Object getFeatureNewValue() {
        return null;
    }

    public Set<EObject> getResultLocus() {
        return Collections.unmodifiableSet(this.resultLocus);
    }

    public EObject getTarget() {
        return this.target;
    }

    public Object putCurrentConstraintData(Object newData) {
        return this.constraintData.put(this.getConstraint(), newData);
    }

    public void skipCurrentConstraintFor(EObject eObject) {
    }

    public void skipCurrentConstraintForAll(Collection<?> eObjects) {
    }

    public void setTarget(EObject target) {
        this.target = target;
        this.resultLocus.clear();
    }

    public void setConstraint(IModelConstraint constraint) {
        this.currentConstraint = constraint;
    }

    public IModelConstraint getConstraint() {
        return this.currentConstraint;
    }

    public IConstraintDescriptor getDescriptor() {
        return this.getConstraint().getDescriptor();
    }
}

