/*
 * Decompiled with CFR 0.152.
 */
package de.ikoffice.widgets;

import de.ikoffice.util.FontsUtils;
import de.ikoffice.widgets.SplitButtonSelectionListener;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class SplitButton
extends Button {
    private static final int DEFAULT_SPACES = 21;
    private static final String EMPTY_SPACE = FontsUtils.getSpaceByWidth(21);
    private static final Color COLOR_WIDGET_NORMAL_SHADOW = Display.getDefault().getSystemColor(18);
    private static final Color COLOR_WIDGET_HIGHLIGHT_SHADOW = Display.getDefault().getSystemColor(20);
    private static final Color COLOR__BLACK = Display.getDefault().getSystemColor(2);
    private List<SplitButtonSelectionListener> listeners = new LinkedList<SplitButtonSelectionListener>();
    private int x1 = -1;
    private int y1 = -1;
    private int x2 = -1;
    private int y2 = -1;
    private Menu menu;

    public SplitButton(Composite parent, int style) {
        super(parent, 8);
        this.setText("");
        super.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle rect = SplitButton.this.getBounds();
                Color oldForeground = e.gc.getForeground();
                Color oldBackground = e.gc.getBackground();
                SplitButton.this.x1 = e.x + rect.width - 20;
                SplitButton.this.y1 = e.y;
                SplitButton.this.x2 = e.x + rect.width;
                SplitButton.this.y2 = e.y + rect.height;
                int dx = -e.gc.getClipping().x;
                int dy = -e.gc.getClipping().y;
                e.gc.setForeground(COLOR_WIDGET_NORMAL_SHADOW);
                e.gc.setBackground(COLOR_WIDGET_NORMAL_SHADOW);
                e.gc.setLineWidth(1);
                e.gc.drawLine(e.x + rect.width - 20 + dx, e.y + 6 + dy, e.x + rect.width - 20 + dx, e.y + rect.height - 6 + dy);
                e.gc.setForeground(COLOR_WIDGET_HIGHLIGHT_SHADOW);
                e.gc.setBackground(COLOR_WIDGET_HIGHLIGHT_SHADOW);
                e.gc.setLineWidth(1);
                e.gc.drawLine(e.x + rect.width - 19 + dx, e.y + 6 + dy, e.x + rect.width - 19 + dx, e.y + rect.height - 6 + dy);
                e.gc.setForeground(COLOR__BLACK);
                e.gc.setBackground(COLOR__BLACK);
                e.gc.fillPolygon(new int[]{e.x + rect.width - 15 + dx, e.y + rect.height / 2 - 1 + dy, e.x + rect.width - 8 + dx, e.y + rect.height / 2 - 1 + dy, e.x + rect.width - 12 + dx, e.y + rect.height / 2 + 3 + dy});
                e.gc.setForeground(oldForeground);
                e.gc.setBackground(oldBackground);
            }
        });
        super.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (SplitButton.this.isShowMenu(event.x, event.y)) {
                    for (SplitButtonSelectionListener listener : SplitButton.this.listeners) {
                        if (listener.showMenu()) continue;
                        return;
                    }
                    Button button = (Button)event.widget;
                    Rectangle rect = button.getBounds();
                    Point p = button.toDisplay(rect.x, rect.y + rect.height);
                    SplitButton.this.getMenu().setLocation(p.x - rect.x, p.y - rect.y);
                    SplitButton.this.getMenu().setVisible(true);
                } else {
                    for (SplitButtonSelectionListener listener : SplitButton.this.listeners) {
                        listener.buttonSelected();
                    }
                }
            }
        });
        this.menu = new Menu((Decorations)this.getShell(), 8);
    }

    private boolean isShowMenu(int x, int y) {
        return x >= this.x1 && y >= this.y1 && x <= this.x2 && y <= this.y2;
    }

    public void addSplitButtonSelectionListener(SplitButtonSelectionListener listener) {
        this.listeners.add(listener);
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    protected void checkSubclass() {
    }

    public void setText(String string) {
        if (string != null) {
            super.setText(String.valueOf(string) + EMPTY_SPACE);
        }
    }

    public String getText() {
        return super.getText().trim();
    }
}

