/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.modelresources.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.model.common.share.modelresources.exceptions.ModelResourceException;
import org.polarsys.kitalpha.model.common.share.modelresources.helpers.DetachmentHelper;
import org.polarsys.kitalpha.model.common.share.modelresources.interfaces.IModelResource;
import org.polarsys.kitalpha.model.common.share.modelresources.interfaces.ModelResourceState;

public class ModelResource
implements IModelResource {
    private URI resourceURI = null;
    private final Collection<EObject> modelObjects = new HashSet<EObject>();
    private final ModelResourceState state;
    private boolean isDeletionCandidate;

    public static IModelResource newResource(URI uri, ModelResourceState state) {
        return new ModelResource(uri, state);
    }

    private ModelResource(URI uri, ModelResourceState state) {
        this.resourceURI = uri;
        this.state = state;
        this.isDeletionCandidate = false;
    }

    @Override
    public URI getResourceURI() throws ModelResourceException {
        if (this.resourceURI == null) {
            throw new ModelResourceException("The resource has no URI");
        }
        return this.resourceURI;
    }

    @Override
    public List<EObject> getModelObjects() throws ModelResourceException {
        if (this.modelObjects == null) {
            throw new ModelResourceException("The list is empty for the resource or null");
        }
        return new ArrayList<EObject>(this.modelObjects);
    }

    @Override
    public void addModelObject(EObject eObject) throws ModelResourceException {
        String eObjectURI = EcoreUtil.getURI((EObject)eObject).trimFragment().toString();
        String resourceUri = this.getResourceURI().toString();
        if (eObjectURI.startsWith("http://") || eObjectURI.isEmpty()) {
            eObjectURI = DetachmentHelper.getPlatformResourceURIFromEObject(eObject).toString();
        }
        if (!resourceUri.equals(eObjectURI)) {
            throw new ModelResourceException("The EObject [" + eObject + "] cannot be added to the resource due to the wrong URI");
        }
        this.modelObjects.add(eObject);
    }

    @Override
    public ModelResourceState getResourceState() {
        return this.state;
    }

    @Override
    public void setAsCandidate(boolean isCandidate) {
        this.isDeletionCandidate = isCandidate;
    }

    @Override
    public boolean isCandidate() {
        return this.isDeletionCandidate;
    }
}

