/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.attachment.ui.merge;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.diffmerge.api.IMergeSelector;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.kitalpha.model.attachment.ui.merge.AttachmentMergeSelector;

public class MergeCommand
extends RecordingCommand {
    private final EditingDomain domain;
    private final IComparisonMethod method;
    private IProgressMonitor monitor;
    private Collection<String> selectedUris;
    private Collection<IDifference> conflicts;

    public MergeCommand(TransactionalEditingDomain domain, IComparisonMethod method, Collection<String> selectedUris, Collection<IDifference> conflicts, IProgressMonitor monitor) {
        super(domain);
        this.domain = domain;
        this.method = method;
        this.selectedUris = selectedUris;
        this.conflicts = conflicts;
        this.monitor = monitor;
    }

    protected void doExecute() {
        try {
            IEditableModelScope ancestorScope;
            Role rightRole;
            IEditableModelScope targetScope;
            Role leftRole = Role.REFERENCE;
            IEditableModelScope sourceScope = this.method.getModelScopeDefinition(leftRole).createScope((Object)this.domain);
            if (sourceScope instanceof IPersistentModelScope) {
                ((IPersistentModelScope)sourceScope).load();
            }
            if ((targetScope = this.method.getModelScopeDefinition(rightRole = Role.TARGET).createScope((Object)this.domain)) instanceof IPersistentModelScope) {
                ((IPersistentModelScope)targetScope).load();
            }
            if ((ancestorScope = null) instanceof IPersistentModelScope) {
                ((IPersistentModelScope)ancestorScope).load();
            }
            EComparisonImpl comparison = new EComparisonImpl(targetScope, sourceScope, ancestorScope);
            comparison.compute(this.method.getMatchPolicy(), this.method.getDiffPolicy(), this.method.getMergePolicy(), this.monitor);
            comparison.isConsistent();
            comparison.getRemainingDifferences();
            comparison.merge((IMergeSelector)new AttachmentMergeSelector(this.selectedUris, this.conflicts), true, this.monitor);
            if (targetScope instanceof IPersistentModelScope.Editable) {
                ((IPersistentModelScope.Editable)targetScope).save();
            }
            comparison.getRemainingDifferences();
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }
}

