/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.coredomain.model.edit.helpers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.model.edit.helpers.DiscardedModels;

public class ModelHelper {
    private String filePattern;

    public ModelHelper(EObject target, String filePattern) {
        this.filePattern = filePattern;
    }

    public static <S> Collection<S> getCandidates(EObject target, Class<S> candidate, String filePattern) {
        ResourceSet resourceSet = target.eResource().getResourceSet();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (URI uri : ModelHelper.getCandidateURIs(target, filePattern)) {
            Resource resource = resourceSet.getResource(uri, true);
            for (EObject eobj : resource.getContents()) {
                if (!candidate.isAssignableFrom(eobj.getClass())) continue;
                result.add(eobj);
            }
        }
        return result;
    }

    public static Collection<URI> getCandidateURIs(EObject target, String filePattern) {
        ModelHelper helper = new ModelHelper(target, filePattern);
        String project = target.eResource().getURI().segment(1);
        IPluginModelBase model = PluginRegistry.findModel((String)project);
        if (model == null) {
            AD_Log.getDefault().logError("Cannot find plugin related to project " + project);
            return Collections.emptyList();
        }
        ArrayList<URI> ecoreUris = new ArrayList<URI>();
        ArrayList<IProject> wsProjects = new ArrayList<IProject>();
        ArrayList<Bundle> pBundles = new ArrayList<Bundle>();
        helper.collectBundles(model, wsProjects, pBundles, new HashSet<String>(300));
        helper.collectFileInPlatform(pBundles, ecoreUris);
        helper.collectFileInWorkspace(wsProjects, ecoreUris);
        URI[] uRIArray = ecoreUris.toArray(new URI[ecoreUris.size()]);
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if (DiscardedModels.isFiltered(uri)) {
                ecoreUris.remove(uri);
            }
            ++n2;
        }
        return ecoreUris;
    }

    private void collectBundles(IPluginModelBase model, List<IProject> wsProjects, List<Bundle> pBundles, Set<String> visited) {
        String symbolicName = model.getBundleDescription().getSymbolicName();
        IResource underlyingResource = model.getUnderlyingResource();
        if (underlyingResource != null) {
            wsProjects.add(underlyingResource.getProject());
        } else {
            Bundle bundle = Platform.getBundle((String)symbolicName);
            pBundles.add(bundle);
        }
        visited.add(symbolicName);
        BundleDescription description = model.getBundleDescription();
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification req = bundleSpecificationArray[n2];
            if (req.getSupplier() == null) {
                AD_Log.getDefault().logWarning("Cannot find plugin related to project " + req.getName());
            } else {
                IPluginModelBase reqModel = PluginRegistry.findModel((BundleDescription)req.getSupplier().getSupplier());
                symbolicName = reqModel.getBundleDescription().getSymbolicName();
                if (!visited.contains(symbolicName)) {
                    this.collectBundles(reqModel, wsProjects, pBundles, visited);
                }
            }
            ++n2;
        }
    }

    private void collectFileInPlatform(List<Bundle> pBundles, List<URI> fileUris) {
        for (Bundle bundle : pBundles) {
            Enumeration e = bundle.findEntries("/", this.filePattern, true);
            while (e != null && e.hasMoreElements()) {
                URL url = (URL)e.nextElement();
                String path = url.getPath();
                URI uri = URI.createPlatformPluginURI((String)(String.valueOf(bundle.getSymbolicName()) + path), (boolean)true);
                fileUris.add(uri);
            }
        }
    }

    private void collectFileInWorkspace(List<IProject> wsProjects, final List<URI> fileUris) {
        String[] fileNamePattern = new String[]{this.filePattern};
        FileTextSearchScope fScope = FileTextSearchScope.newSearchScope((IResource[])wsProjects.toArray(new IResource[wsProjects.size()]), (String[])fileNamePattern, (boolean)true);
        TextSearchRequestor requestor = new TextSearchRequestor(){

            public boolean acceptFile(IFile file) throws CoreException {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true);
                fileUris.add(uri);
                return super.acceptFile(file);
            }
        };
        Pattern searchPattern = Pattern.compile("");
        TextSearchEngine.create().search((TextSearchScope)fScope, requestor, searchPattern, null);
    }
}

