/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.ejbweb.xa;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import jakarta.transaction.UserTransaction;
import java.util.Enumeration;
import java.util.Properties;

public class TransactionTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejbweb.xa.TransactionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private TSNamingContextInterface context = null;
    private Properties props = null;
    private String jmsUser;
    private String jmsPassword;
    long timeout;
    private transient QueueConnection qConnect = null;
    private transient Queue bmtQ = null;
    private transient QueueSession qSession = null;
    private transient QueueConnectionFactory qFactory = null;
    private transient QueueSender qSender = null;
    private transient QueueReceiver qReceiver = null;
    private transient Topic bmtT = null;
    private transient TopicConnection tConnect = null;
    private transient TopicSession tSession = null;
    private transient TopicConnectionFactory tFactory = null;
    private transient TopicPublisher tPublisher = null;
    private transient TopicSubscriber tSub = null;
    private transient TextMessage msg = null;
    private transient UserTransaction ut = null;
    private boolean transacted = true;
    private boolean queueTest = false;

    public static void main(String[] args) {
        TransactionTests theTests = new TransactionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        try {
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.jmsUser == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.jmsPassword == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.bmtQ = (Queue)this.context.lookup("java:comp/env/jms/QUEUE_BMT");
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            this.bmtT = (Topic)this.context.lookup("java:comp/env/jms/TOPIC_BMT");
            this.ut = (UserTransaction)this.context.lookup("java:comp/UserTransaction");
            TestUtil.logTrace((String)"in client setup");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            this.logTrace("Cleanup");
            try {
                if (this.ut != null && this.ut.getStatus() != 6) {
                    this.logTrace("Cleanup open transaction");
                    this.printTxStatus();
                    this.ut.commit();
                }
            }
            catch (Exception e) {
                this.logErr("Exception during cleanup of transaction", e);
            }
            try {
                if (this.queueTest) {
                    this.logTrace("Cleanup of Queue and close receiver/sender");
                    this.flushQueue(this.qSession, this.qReceiver, this.bmtQ);
                    this.logTrace("Closing receiver and sender");
                    if (this.qReceiver != null) {
                        this.qReceiver.close();
                    }
                    if (this.qSender != null) {
                        this.qSender.close();
                    }
                    this.qReceiver = null;
                    this.qSender = null;
                } else {
                    this.logTrace("Cleanup of Topic and close publisher");
                    if (this.tPublisher != null) {
                        this.tPublisher.close();
                    }
                    this.tPublisher = null;
                }
            }
            catch (Exception e) {
                if (this.queueTest) {
                    this.logErr("Exception during cleanup of Queue", e);
                }
                this.logErr("Exception during cleanup of Topic", e);
            }
            try {
                this.logTrace("Closing sessions");
                if (this.tSession != null) {
                    this.tSession.close();
                }
                if (this.qSession != null) {
                    this.qSession.close();
                }
                this.tSession = null;
                this.qSession = null;
            }
            catch (Exception e) {
                this.logErr("Exception during closing of sessions", e);
            }
            try {
                this.logTrace("Closing connections");
                if (this.tConnect != null) {
                    this.tConnect.close();
                }
                if (this.qConnect != null) {
                    this.qConnect.close();
                }
                this.tConnect = null;
                this.qConnect = null;
            }
            catch (Exception e) {
                this.logErr("Exception during closing of connections", e);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    private void cleanupSubscription(TopicSubscriber sub, TopicSession session, String subName) {
        if (sub != null) {
            try {
                TestUtil.logTrace((String)("Closing durable subscriber: " + sub));
                sub.close();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during close: ", (Throwable)e);
            }
        }
        if (session != null) {
            try {
                TestUtil.logTrace((String)("Unsubscribing \"" + subName + "\""));
                session.unsubscribe(subName);
            }
            catch (Exception e) {
                TestUtil.logErr((String)"exception during unsubscribe: ", (Throwable)e);
            }
        }
    }

    private void flushQueue(QueueSession qSession, QueueReceiver qReceiver, Queue queue) throws Exception {
        int numMsgsFlushed = 0;
        int numMsgs = 0;
        Enumeration msgs = null;
        try {
            TestUtil.logTrace((String)("Flush Queue " + queue.getQueueName()));
            QueueBrowser qBrowser = qSession.createBrowser(queue);
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            qBrowser.close();
            if (numMsgs == 0) {
                TestUtil.logTrace((String)("No Messages left on Queue " + queue.getQueueName()));
            } else {
                TestUtil.logTrace((String)(numMsgs + " Messages left on Queue " + queue.getQueueName()));
                Message msg = qReceiver.receiveNoWait();
                while (msg != null) {
                    ++numMsgsFlushed;
                    msg = qReceiver.receiveNoWait();
                }
                if (numMsgsFlushed > 0) {
                    TestUtil.logMsg((String)("flush queue of " + numMsgsFlushed + " messages"));
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void printTxStatus() {
        int status;
        this.logTrace("Transaction Status: ");
        try {
            status = this.ut.getStatus();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logTrace("Unable to get transaction status");
            return;
        }
        switch (status) {
            case 0: {
                this.logTrace("==== A transaction is associated with the target object and it is in the active state.");
                break;
            }
            case 3: {
                this.logTrace("==== A transaction is associated with the target object and it has been committed..");
                break;
            }
            case 8: {
                this.logTrace("==== A transaction is associated with the target object and it is in the process of committing.");
                break;
            }
            case 1: {
                this.logTrace("==== A transaction is associated with the target object and it has been marked forrollback, perhaps as a result of a setRollbackOnly operation. ");
                break;
            }
            case 6: {
                this.logTrace("==== No transaction is currently associated with the target object.");
                break;
            }
            case 2: {
                this.logTrace("====A transaction is associated with the target object and it has been prepared, i.e. ");
                break;
            }
            case 7: {
                this.logTrace("==== A transaction is associated with the target object and it is in the process of preparing. ");
                break;
            }
            case 4: {
                this.logTrace("==== A transaction is associated with the target object and the outcome has been determined as rollback. ");
                break;
            }
            case 9: {
                this.logTrace("==== A transaction is associated with the target object and it is in the process of rolling back.");
                break;
            }
            case 5: {
                this.logTrace("==== A transaction is associated with the target object but its current status cannot be  determined ");
                break;
            }
            default: {
                TestUtil.logTrace((String)("??? jakarta.transaction.Status is  " + status));
            }
        }
    }

    private void createTestMessage(String TestCase, int num) throws Exception {
        this.logTrace("Invoked createTestMessage");
        String myMessage = "EjbWebTransaction tests";
        try {
            this.msg = this.queueTest ? this.qSession.createTextMessage() : this.tSession.createTextMessage();
            this.msg.setText(myMessage);
            this.msg.setIntProperty("TestCaseNum", num);
            this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", TestCase);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Error in createTestMessage!");
        }
    }

    private void testInitForQ(String TestCase, int TestNum) throws Exception {
        try {
            this.logMsg("TestCase = " + TestCase);
            this.queueTest = true;
            this.logMsg("Create QueueConnection, start user transaction, create QueueSession");
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            this.qConnect.start();
            this.ut.begin();
            this.qSession = this.qConnect.createQueueSession(this.transacted, 0);
            this.logMsg("Create receiver and sender");
            this.qReceiver = this.qSession.createReceiver(this.bmtQ);
            this.qSender = this.qSession.createSender(this.bmtQ);
            this.logMsg("Construct a test message for this test case");
            this.createTestMessage(TestCase, TestNum);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Error in testInitForQ!");
        }
    }

    private void testInitForT(String TestCase, int TestNum) throws Exception {
        try {
            this.logMsg("TestCase = " + TestCase);
            this.queueTest = false;
            this.logMsg("Create TopicConnection, start user transaction, create TopicSession");
            this.tConnect = this.tFactory.createTopicConnection(this.jmsUser, this.jmsPassword);
            this.tConnect.start();
            this.ut.begin();
            this.tSession = this.tConnect.createTopicSession(this.transacted, 0);
            this.logMsg("Create subscriber and publisher with TestCase as subscription name");
            this.tSub = this.tSession.createDurableSubscriber(this.bmtT, TestCase);
            this.tPublisher = this.tSession.createPublisher(this.bmtT);
            this.logMsg("Construct a test message for this test case");
            this.createTestMessage(TestCase, TestNum);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Error in testInitForT!");
        }
    }

    public void Test01() throws Exception {
        String TestCase = "Test01";
        int TestNum = 1;
        try {
            this.testInitForQ(TestCase, TestNum);
            this.logMsg("Begin TX: sending test message to Queue then: Commit TX");
            this.qSender.send((Message)this.msg);
            this.ut.commit();
            this.ut.begin();
            this.logMsg("Begin TX: receiving test message from Queue then: Commit TX");
            TextMessage msgRec = (TextMessage)this.qReceiver.receive(this.timeout);
            this.ut.commit();
            this.logMsg("Verify message received");
            if (msgRec == null) {
                this.logMsg("Test " + TestNum + " Fail!");
                throw new Exception("Message was not received");
            }
            if (msgRec.getIntProperty("TestCaseNum") != TestNum) {
                this.logMsg("Unknown Message was received in error");
                this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                throw new Exception("Unknown Message was received in error");
            }
            this.logMsg("Test " + TestNum + " Pass!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void Test02() throws Exception {
        String TestCase = "Test02";
        int TestNum = 2;
        try {
            this.testInitForQ(TestCase, TestNum);
            this.logMsg("Begin TX: sending test message to Queue then: Rollback TX");
            this.qSender.send((Message)this.msg);
            this.ut.rollback();
            this.ut.begin();
            this.logMsg("Begin TX: try receiving test message from Queue then: Commit TX");
            TextMessage msgRec = (TextMessage)this.qReceiver.receive(this.timeout);
            this.ut.commit();
            this.logMsg("Verify no message received");
            if (msgRec != null) {
                if (msgRec.getIntProperty("TestCaseNum") == TestNum) {
                    this.logMsg("Test " + TestNum + " Fail!");
                    throw new Exception("Message was received in error");
                }
                this.logMsg("Unknown Message was received in error");
                this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                throw new Exception("Unknown Message was received in error");
            }
            this.logMsg("Test " + TestNum + " Pass!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void Test03() throws Exception {
        String TestCase = "Test03";
        int TestNum = 3;
        try {
            this.testInitForQ(TestCase, TestNum);
            this.logMsg("Begin TX: sending test message to Queue then: Commit TX");
            this.qSender.send((Message)this.msg);
            this.ut.commit();
            this.ut.begin();
            this.logMsg("Begin TX: receiving test message from Queue then: Commit TX");
            TextMessage msgRec = (TextMessage)this.qReceiver.receive(this.timeout);
            this.ut.commit();
            if (msgRec == null) {
                throw new Exception("Unable to complete test! Did not receive a message");
            }
            this.ut.begin();
            this.logMsg("Begin TX: receiving test message again from Queue then: Commit TX");
            msgRec = (TextMessage)this.qReceiver.receive(this.timeout);
            this.ut.commit();
            this.logMsg("Verify no message received");
            if (msgRec != null) {
                if (msgRec.getIntProperty("TestCaseNum") == TestNum) {
                    this.logMsg("Test " + TestNum + " Fail!");
                    throw new Exception("Message was received in error");
                }
                this.logMsg("Unknown Message was received in error");
                this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                throw new Exception("Unknown Message was received in error");
            }
            this.logMsg("Test " + TestNum + " Pass!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void Test04() throws Exception {
        String TestCase = "Test04";
        int TestNum = 4;
        try {
            this.testInitForQ(TestCase, TestNum);
            this.logMsg("Begin TX: sending test message to Queue then: Commit TX");
            this.qSender.send((Message)this.msg);
            this.ut.commit();
            this.ut.begin();
            this.logMsg("Begin TX: receiving test message from Queue then: Rollback TX");
            TextMessage msgRec = (TextMessage)this.qReceiver.receive(this.timeout);
            this.ut.rollback();
            this.ut.begin();
            this.logMsg("Begin TX: receiving test message again from Queue then: Commit TX");
            msgRec = (TextMessage)this.qReceiver.receive(this.timeout);
            this.ut.commit();
            this.logMsg("Verify message received");
            if (msgRec == null) {
                this.logMsg("Test " + TestNum + " Fail!");
                throw new Exception("Message was not received ");
            }
            if (msgRec.getIntProperty("TestCaseNum") != TestNum) {
                this.logMsg("Unknown Message was received in error");
                this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                throw new Exception("Unknown Message was received in error");
            }
            this.logMsg("Test " + TestNum + " Pass!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void Test05() throws Exception {
        block7: {
            String TestCase = "Test05";
            int TestNum = 5;
            try {
                this.testInitForT(TestCase, TestNum);
                this.logMsg("Begin TX: sending test message to Topic then: Commit TX");
                this.tPublisher.publish((Message)this.msg);
                this.ut.commit();
                this.ut.begin();
                this.logMsg("Begin TX: receiving test message from Topic then: Commit TX");
                TextMessage msgRec = (TextMessage)this.tSub.receive(this.timeout);
                this.ut.commit();
                this.logMsg("Verify message received");
                if (msgRec == null) {
                    this.logMsg("Test " + TestNum + " Fail!");
                    throw new Exception("Message was not received");
                }
                if (msgRec.getIntProperty("TestCaseNum") == TestNum) {
                    this.logMsg("Test " + TestNum + " Pass!");
                    break block7;
                }
                this.logMsg("Unknown Message was received in error");
                this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                throw new Exception("Unknown Message was received in error");
            }
            catch (Exception e) {
                throw new Exception("Test Failed!", e);
            }
            finally {
                this.cleanupSubscription(this.tSub, this.tSession, TestCase);
            }
        }
    }

    public void Test06() throws Exception {
        block7: {
            String TestCase = "Test06";
            int TestNum = 6;
            try {
                this.testInitForT(TestCase, TestNum);
                this.logMsg("Begin TX: sending test message to Topic then: Rollback TX");
                this.tPublisher.publish((Message)this.msg);
                this.ut.rollback();
                this.ut.begin();
                this.logMsg("Begin TX: receiving test message from Topic then: Commit TX");
                TextMessage msgRec = (TextMessage)this.tSub.receive(this.timeout);
                this.ut.commit();
                this.logMsg("Verify no message received");
                if (msgRec == null) {
                    this.logMsg("Test " + TestNum + " Pass!");
                    break block7;
                }
                if (msgRec.getIntProperty("TestCaseNum") == TestNum) {
                    this.logMsg("Test " + TestNum + " Fail!");
                    throw new Exception("Message was received in error");
                }
                this.logMsg("Unknown Message was received in error");
                this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                throw new Exception("Unknown Message was received in error");
            }
            catch (Exception e) {
                throw new Exception("Test Failed!", e);
            }
            finally {
                this.cleanupSubscription(this.tSub, this.tSession, TestCase);
            }
        }
    }

    public void Test07() throws Exception {
        block8: {
            String TestCase = "Test07";
            int TestNum = 7;
            try {
                this.testInitForT(TestCase, TestNum);
                this.logMsg("Begin TX: sending test message to Topic then: Commit TX");
                this.tPublisher.publish((Message)this.msg);
                this.ut.commit();
                this.ut.begin();
                this.logMsg("Begin TX: receiving test message from Topic then: Commit TX");
                TextMessage msgRec = (TextMessage)this.tSub.receive(this.timeout);
                this.ut.commit();
                if (msgRec == null) {
                    throw new Exception("Unable to complete test! Did not receive a message");
                }
                this.ut.begin();
                this.logMsg("Begin TX: receiving test message again from Topic then: Commit TX");
                msgRec = (TextMessage)this.tSub.receive(this.timeout);
                this.ut.commit();
                this.logMsg("Verify no message received");
                if (msgRec == null) {
                    this.logMsg("Test " + TestNum + " Pass!");
                    break block8;
                }
                if (msgRec.getIntProperty("TestCaseNum") == TestNum) {
                    this.logMsg("Test " + TestNum + " Fail!");
                    throw new Exception("Message was received in error");
                }
                this.logMsg("Unknown Message was received in error");
                this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                throw new Exception("Unknown Message was received in error");
            }
            catch (Exception e) {
                throw new Exception("Test Failed!", e);
            }
            finally {
                this.cleanupSubscription(this.tSub, this.tSession, TestCase);
            }
        }
    }

    public void Test08() throws Exception {
        block8: {
            String TestCase = "Test08";
            int TestNum = 8;
            try {
                this.testInitForT(TestCase, TestNum);
                this.logMsg("Begin TX: sending test message to Topic then: Commit TX");
                this.tPublisher.publish((Message)this.msg);
                this.ut.commit();
                this.ut.begin();
                this.logMsg("Begin TX: receiving test message from Topic then: Rollback TX");
                TextMessage msgRec = (TextMessage)this.tSub.receive(this.timeout);
                this.ut.rollback();
                if (msgRec == null) {
                    throw new Exception("Unable to complete test! Did not receive a message");
                }
                this.ut.begin();
                this.logMsg("Begin TX: receiving test message again from Topic then: Commit TX");
                msgRec = (TextMessage)this.tSub.receive(this.timeout);
                this.ut.commit();
                this.logMsg("Verify message received");
                if (msgRec == null) {
                    this.logMsg("Test " + TestNum + " Failed!");
                    throw new Exception("Message was not received ");
                }
                if (msgRec.getIntProperty("TestCaseNum") == TestNum) {
                    this.logMsg("Test " + TestNum + " Pass!");
                    break block8;
                }
                this.logMsg("Unknown Test Message " + TestNum + " Fail!");
                this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                throw new Exception("Unknown Message was received in error");
            }
            catch (Exception e) {
                throw new Exception("Test Failed!", e);
            }
            finally {
                this.cleanupSubscription(this.tSub, this.tSession, TestCase);
            }
        }
    }

    public void Test09() throws Exception {
        String TestCase = "Test09";
        int TestNum = 9;
        try {
            this.testInitForQ(TestCase, TestNum);
            this.logMsg("Begin TX: sending test message to Queue then: Commit TX");
            this.qSender.send((Message)this.msg);
            this.ut.commit();
            this.ut.begin();
            this.logMsg("Begin TX: sending test message again to Queue then: Commit TX");
            this.qSender.send((Message)this.msg);
            this.ut.commit();
            for (int i = 0; i < 2; ++i) {
                this.ut.begin();
                this.logMsg("Begin TX: receiving test message from Queue then: Commit TX");
                TextMessage msgRec = (TextMessage)this.qReceiver.receive(this.timeout);
                this.ut.commit();
                this.logMsg("Verify message received");
                if (msgRec == null) {
                    this.logMsg("Test " + TestNum + " Fail!");
                    throw new Exception("Message was not received");
                }
                if (msgRec.getIntProperty("TestCaseNum") != TestNum) {
                    this.logMsg("Unknown Message was received in error");
                    this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                    throw new Exception("Unknown Message was received in error");
                }
                this.logMsg("Test " + TestNum + " Pass!");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void Test10() throws Exception {
        String TestCase = "Test10";
        int TestNum = 10;
        try {
            this.testInitForT(TestCase, TestNum);
            this.logMsg("Begin TX: sending test message to Topic then: Commit TX");
            this.tPublisher.publish((Message)this.msg);
            this.ut.commit();
            this.ut.begin();
            this.logMsg("Begin TX: sending test message again to Topic then: Commit TX");
            this.tPublisher.publish((Message)this.msg);
            this.ut.commit();
            for (int i = 0; i < 2; ++i) {
                this.ut.begin();
                this.logMsg("Begin TX: receiving test message from Queue then: Commit TX");
                TextMessage msgRec = (TextMessage)this.tSub.receive(this.timeout);
                this.ut.commit();
                this.logMsg("Verify message received");
                if (msgRec == null) {
                    this.logMsg("Test " + TestNum + " Fail!");
                    throw new Exception("Message was not received");
                }
                if (msgRec.getIntProperty("TestCaseNum") != TestNum) {
                    this.logMsg("Unknown Message was received in error");
                    this.logMsg("msgRec.getIntProperty(\"TestCaseNum\")=" + msgRec.getIntProperty("TestCaseNum") + " expected " + TestNum);
                    throw new Exception("Unknown Message was received in error");
                }
                this.logMsg("Test " + TestNum + " Pass!");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
        finally {
            this.cleanupSubscription(this.tSub, this.tSession, TestCase);
        }
    }
}

