/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.taskdefs.common.RunCTSProcIntf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class RunCTS
extends Task {
    private static final String DEFAULT_LOG_FILE = System.getProperty("java.io.tmpdir", "/tmp") + File.separator + "RunCTSAntLog.txt";
    private static final String NL = System.getProperty("line.separator", "\n");
    private static final String PASSWORD_FILE_NAME = "password.txt";
    private File reportdir;
    private File workdir;
    private File tshome;
    private File j2eehome;
    private File tshomebin;
    private File tshomebincommon;
    private File j2eehomebin;
    private File javahome;
    private File rijava;
    private File windir;
    private File tempdir;
    private File systemroot;
    private File spshome;
    private File anthome;
    private File logfile;
    private File coverageconfigfile;
    private String[] env;
    private String[] testareas;
    private String asadmin;
    private String tsant;
    private String tstests;
    private List preprocs;
    private List postprocs;
    private File currentTestDir;
    private Process proc;
    private StreamWatcher errThread;
    private StreamWatcher outThread;
    private List procs = new ArrayList();
    private List threads = new ArrayList();
    private Properties processorProps = new Properties();
    private FileWriter antLog;
    private File jdkversion;
    private boolean inited;
    private String username = "admin";
    private String password = "adminadmin";
    private File passwordfile;
    private boolean remoteinstance;
    private String adminport = "4849";
    private String instancename = "server-1";
    private String hostname = "localhost";
    private boolean is9;
    private String runclientargs = "";
    private long jointimeout = 180000L;
    private String antopts;
    private String deliverabledir;
    private boolean bufferingenabled;
    private boolean buildJwsJaxws = true;
    private boolean skipserverrestart;

    public void setSkipServerRestart(boolean value) {
        this.skipserverrestart = value;
    }

    public void setBuildJwsJaxws(boolean value) {
        this.buildJwsJaxws = value;
    }

    public void setBufferingEnabled(boolean value) {
        this.bufferingenabled = value;
    }

    public void setDeliverabledir(String dir) {
        this.deliverabledir = dir;
    }

    public void setAntopts(String antopts) {
        this.antopts = antopts;
    }

    public void setJointimeout(long jointimeout) {
        this.jointimeout = jointimeout * 1000L;
    }

    public void setRunclientargs(String runclientargs) {
        this.runclientargs = runclientargs;
    }

    public void setRemoteinstance(boolean value) {
        this.remoteinstance = value;
    }

    public void setAdminport(String adminport) {
        this.adminport = adminport;
    }

    public void setInstancename(String instancename) {
        this.instancename = instancename;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordfile(File passwordfile) {
        this.passwordfile = passwordfile;
    }

    public void setReportdir(File reportdir) {
        this.reportdir = reportdir;
    }

    public void setWorkdir(File workdir) {
        this.workdir = workdir;
    }

    public void setTshome(File tshome) {
        this.tshome = tshome;
    }

    public void setJ2eehome(File j2eehome) {
        this.j2eehome = j2eehome;
    }

    public void setSpshome(File spshome) {
        this.spshome = spshome;
    }

    public void setLogfile(File logfile) {
        this.logfile = logfile;
    }

    public void setCoverageconfigfile(File coverageconfigfile) {
        this.coverageconfigfile = coverageconfigfile;
    }

    public void setTestareas(String testareas) {
        String delimiters = " \t\n\r\f,";
        StringTokenizer tokens = new StringTokenizer(testareas, delimiters);
        this.testareas = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            this.testareas[i] = Project.translatePath((String)tokens.nextToken().trim());
            ++i;
        }
    }

    public void setPreprocs(String procs) {
        this.preprocs = this.createObjects(procs);
    }

    public void setPostprocs(String procs) {
        this.postprocs = this.createObjects(procs);
    }

    private List createObjects(String classes) {
        ArrayList result = new ArrayList();
        String delimiters = " \t\n\r\f,";
        StringTokenizer tokens = new StringTokenizer(classes, delimiters);
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String className = tokens.nextToken().trim();
            try {
                Class<?> clazz = Class.forName(className);
                result.add(clazz.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    public void setJdkversion(File jdkversion) {
        this.jdkversion = jdkversion;
        if (jdkversion.isFile()) {
            jdkversion.delete();
        }
    }

    private void writeJDKVersion() throws BuildException {
        if (!this.inited && this.jdkversion != null) {
            String version = System.getProperty("java.version");
            OutputStreamWriter out = null;
            this.inited = true;
            try {
                out = new FileWriter(this.jdkversion);
                out.write(version + NL);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            finally {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void execute() throws BuildException {
        this.setProps();
        this.log("Report Directory          : \"" + this.reportdir + "\"", 3);
        this.log("Work Directory            : \"" + this.workdir + "\"", 3);
        this.log("TS_HOME                   : \"" + this.tshome + "\"", 3);
        this.log("J2EE_HOME                 : \"" + this.j2eehome + "\"", 3);
        this.log("S1AS_HOME                 : \"" + this.j2eehome + "\"", 3);
        this.log("SPS_HOME                  : \"" + this.spshome + "\"", 3);
        this.log("ANT_OPTS                  : \"" + this.antopts + "\"", 3);
        this.log("jointimeout (milliseconds): \"" + this.jointimeout + "\"", 3);
        this.log("deliverabledir            : \"" + this.deliverabledir + "\"", 3);
        this.log("bin dir                   : \"" + this.tshomebin.getPath() + "\"", 3);
        this.log("common bin dir            : \"" + this.tshomebincommon.getPath() + "\"", 3);
        this.log("bufferingenabled          : \"" + this.bufferingenabled + "\"", 3);
        this.log("buildJwsJaxws             : \"" + this.buildJwsJaxws + "\"", 3);
        this.log("skipserverrestart         : \"" + this.skipserverrestart + "\"", 3);
        if (this.windir != null) {
            this.log("windir                    : \"" + this.windir.getPath() + "\"", 3);
            this.log("tempdir                    : \"" + this.tempdir.getPath() + "\"", 3);
        }
        if (this.systemroot != null) {
            this.log("systemroot                : \"" + this.systemroot.getPath() + "\"", 3);
        }
        this.checkPreConditions();
        this.adjustFor90();
        this.initLogFile();
        this.writeJDKVersion();
        this.runTests();
        this.finiLogFile();
    }

    private void adjustFor90() throws BuildException {
        try {
            StringBuffer buf = this.runAsadmin("version");
            this.is9 = (buf.indexOf("8.") == -1 || buf.indexOf("GlassFish") != -1) && buf.indexOf("Reference Implementation 1.4") == -1;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (this.is9 && this.passwordfile == null) {
            this.passwordfile = new File(this.tshomebin, PASSWORD_FILE_NAME);
        }
        if (this.is9 && !this.passwordfile.isFile()) {
            throw new BuildException("The passwordfile, \"" + this.passwordfile + "\", does not exist, specify a valid password file using the passwordfile attribute");
        }
        this.log("Running against GlassFish is " + this.is9, 2);
    }

    private void finiLogFile() {
        try {
            this.antLogWrite(NL + "LOG ENDED" + NL);
            this.log("Log File       : \"" + this.logfile + "\" closed", 3);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                this.antLog.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void initLogFile() {
        try {
            this.antLog = new FileWriter(this.logfile, true);
            this.antLogWrite("LOG STARTED" + NL);
            this.log("Log File       : \"" + this.logfile + "\" opened", 3);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String getDate() {
        return DateFormat.getDateInstance().format(new Date());
    }

    private void runTests() throws BuildException {
        for (int i = 0; i < this.testareas.length; ++i) {
            String testarea = this.testareas[i];
            try {
                if (this.skipserverrestart) {
                    this.log("Note: Skipping server restart", 2);
                } else {
                    this.restartServer(testarea);
                }
                this.runTestArea(testarea);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log("ERROR running test area \"" + testarea + "\"", 0);
                this.antLogWrite("ERROR running test area \"" + testarea + "\"" + NL);
            }
            this.antLogWrite("Completed test area \"" + testarea + "\"" + NL);
        }
        this.killProcs();
        this.killThreads();
    }

    private void antLogWrite(String data) {
        try {
            this.antLog.write(this.getDate() + ": " + data + NL);
            this.antLog.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void runProcessors(String testDirectory, List procs) throws Exception {
        RunCTSProcIntf proc;
        boolean result;
        int numProcs = procs == null ? 0 : procs.size();
        for (int i = 0; i < numProcs && (result = (proc = (RunCTSProcIntf)procs.get(i)).execute(testDirectory, this.project, this.processorProps)); ++i) {
        }
    }

    private void runTestArea(String testArea) throws Exception {
        String testDirectory = this.tstests + File.separator + testArea;
        this.currentTestDir = new File(testDirectory);
        String command = "runclient " + this.runclientargs + " -Dreport.dir=" + this.reportdir.getPath() + File.separator + this.mapTestArea(testArea) + " -Dwork.dir=" + this.workdir.getPath() + File.separator + this.mapTestArea(testArea);
        if (!this.currentTestDir.isDirectory()) {
            throw new BuildException("Directory does not exist \"" + this.currentTestDir + "\"");
        }
        if (testArea.startsWith("webservices12")) {
            this.enableWebservicesClients();
        }
        if (testArea.startsWith("jacc")) {
            this.enableJacc();
        }
        if (testArea.startsWith("rmiiiop")) {
            this.startRmiiiopServer();
        }
        if (testArea.startsWith("ejb30/lite")) {
            this.configureDataSourceTests();
        }
        if (testArea.startsWith("jaspic")) {
            this.enableJaspic();
        }
        if (testArea.startsWith("pluggability")) {
            this.enableTsPersistenceProvider();
        }
        if (testArea.startsWith("jaxrs")) {
            this.updateJaxRSWars();
        }
        if (testArea.startsWith("jws")) {
            this.buildReverse("jws");
        }
        if (testArea.startsWith("jaxws")) {
            this.buildReverse("jaxws");
        }
        this.log("Testing \"" + this.currentTestDir + "\"", 2);
        this.runProcessors(testDirectory, this.preprocs);
        this.runTsant(command, this.currentTestDir);
        this.runProcessors(testDirectory, this.postprocs);
        this.log("Completed \"" + this.currentTestDir + "\"", 2);
        if (testArea.startsWith("jacc")) {
            this.disableJacc();
        }
        if (testArea.startsWith("jaspic")) {
            this.disableJaspic();
        }
        if (testArea.startsWith("pluggability")) {
            this.disableTsPersistenceProvider();
        }
    }

    private void killProcs() {
        int numProcs = this.procs.size();
        for (int i = 0; i < numProcs; ++i) {
            Process proc = (Process)this.procs.get(i);
            try {
                proc.destroy();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void killThreads() {
        int numThreads = this.threads.size();
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = (Thread)this.threads.get(i);
            try {
                thread.interrupt();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void enableWebservicesClients() throws Exception {
        this.log("Building webservices clients ...", 2);
        this.runTsant("build.special.webservices.clients", this.tshomebin, true);
        this.log("Webservices clients built.", 2);
    }

    private void enableJacc() throws Exception {
        this.log("Enabling JACC...", 2);
        this.runTsant("-f xml/impl/glassfish/s1as.xml create.jacc.vm.options", this.tshomebincommon, true);
        this.restartServer();
        this.log("JACC Enabled.", 2);
    }

    private void configureDataSourceTests() throws Exception {
        this.log("Configuring data sources for EJB30 Lite...", 2);
        this.runTsant("configure.datasource.tests", this.tshomebin, true);
        this.log("Data sources configured for EJB30 Lite.", 2);
    }

    private void enableJaspic() throws Exception {
        this.log("Enabling JASPIC...", 2);
        this.runTsant("enable.jaspic", this.tshomebin, true);
        this.log("JASPIC Enabled.", 2);
    }

    private void enableTsPersistenceProvider() throws Exception {
        this.log("Enabling TS Persistence Provider...", 2);
        this.runTsant("enable.ts.persistence.provider", this.tshomebin, true);
        this.log("TS Persistence Provider Enabled.", 2);
    }

    private void updateJaxRSWars() throws Exception {
        this.log("Updating JAXRS Wars...", 2);
        this.runTsant("update.jaxrs.wars", this.tshomebin, true);
        this.log("JAXRS Wars Updated.", 2);
    }

    private void buildReverse(String area) throws Exception {
        int index;
        boolean runBuild = this.buildJwsJaxws;
        if (this.runclientargs.length() > 0 && runBuild && (index = this.runclientargs.indexOf("-Dkeywords=")) != -1) {
            int index2 = this.runclientargs.indexOf("forward");
            int index3 = this.runclientargs.indexOf("reverse");
            boolean bl = runBuild = index2 != -1 && index3 == -1;
        }
        if (runBuild) {
            this.log("Building reverse tests for " + area + "...", 2);
            String dir = this.tstests + File.separator + area;
            File dirFile = new File(dir);
            this.runTsant("-Dbuild.vi=true build", dirFile, true);
            this.log("Reverse tests built for " + area + ".", 2);
        } else {
            this.log("Skipping build of reverse tests for " + area + "...", 2);
        }
    }

    private void disableJaspic() throws Exception {
        this.log("Disabling JASPIC...", 2);
        this.runTsant("disable.jaspic", this.tshomebin, true);
        this.log("JASPIC Disabled.", 2);
    }

    private void disableTsPersistenceProvider() throws Exception {
        this.log("Disabling TS Persistence Provider...", 2);
        this.runTsant("disable.ts.persistence.provider", this.tshomebin, true);
        this.log("TS Persistence Provider Disabled.", 2);
    }

    private void disableJacc() throws Exception {
        this.log("Disabling JACC...", 2);
        this.runTsant("-f xml/impl/glassfish/s1as.xml delete.jacc.vm.options", this.tshomebincommon, true);
        this.restartServer();
        this.log("JACC Disabled.", 2);
    }

    private void startRmiiiopServer() throws Exception {
        this.log("Starting RMIIIOP Server...", 2);
        this.runTsant("start.rmiiiop.server", this.tshomebin, false);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log("RMIIIOP Server Started.", 2);
    }

    private void checkPreConditions() throws BuildException {
        if (this.tshome == null || this.reportdir == null || this.workdir == null || this.j2eehome == null) {
            throw new BuildException("Must specify the attributes: reportdir, workdir, tshome and j2eehome.");
        }
        if (this.testareas.length == 0) {
            throw new BuildException("Must specify at least on test area to run");
        }
        if (!this.tshome.isDirectory()) {
            throw new BuildException("The specified tshome attribute, \"" + this.tshome + "\", does not exist");
        }
        if (!this.j2eehome.isDirectory()) {
            throw new BuildException("The specified j2eehome attribute, \"" + this.j2eehome + "\", does not exist");
        }
        for (int i = 0; i < this.testareas.length; ++i) {
            String testarea = this.testareas[i];
            this.currentTestDir = new File(this.tstests + File.separator + testarea);
            if (this.currentTestDir.isDirectory()) continue;
            throw new BuildException("The specified test directory does not exist, \"" + this.currentTestDir + "\"");
        }
        if (this.coverageconfigfile != null && !this.coverageconfigfile.isFile()) {
            throw new BuildException("The specified coverage config file does not exist, \"" + this.coverageconfigfile + "\"");
        }
        if (this.logfile == null) {
            this.logfile = new File(DEFAULT_LOG_FILE);
        }
        if (this.logfile.isFile()) {
            this.logfile.delete();
        }
    }

    private void setProps() {
        String osname = System.getProperty("os.name");
        this.asadmin = this.j2eehome.getPath() + File.separator + "bin" + File.separator + "asadmin";
        this.anthome = new File(System.getProperty("ant.home"));
        this.tsant = this.anthome.getPath() + File.separator + "bin" + File.separator + "ant";
        this.tstests = this.tshome.getPath() + File.separator + "src" + File.separator + "com" + File.separator + "sun" + File.separator + "ts" + File.separator + "tests";
        this.javahome = new File(System.getProperty("java.home"));
        this.rijava = System.getenv("RI_JAVA_HOME") != null ? new File(System.getenv("RI_JAVA_HOME")) : this.javahome;
        this.tshomebincommon = new File(this.tshome, "bin");
        this.tshomebin = new File(this.tshome, "install/" + this.deliverabledir + "/bin");
        if (!this.tshomebin.isDirectory()) {
            this.tshomebin = this.tshomebincommon;
        }
        this.j2eehomebin = new File(this.j2eehome, "bin");
        if (this.antopts == null || this.antopts.length() == 0) {
            this.antopts = "-Djava.endorsed.dirs=" + this.j2eehome.getPath() + File.separator + "modules" + File.separator + "endorsed";
        }
        this.processorProps.setProperty("j2ee.home", this.j2eehome.getPath());
        this.processorProps.setProperty("ts.home", this.tshome.getPath());
        String spsHome = "";
        if (this.spshome != null) {
            this.processorProps.setProperty("sps.home", this.spshome.getPath());
            spsHome = this.spshome.getPath();
        }
        if (this.deliverabledir == null || this.deliverabledir.length() == 0) {
            this.deliverabledir = "j2ee";
        }
        if (osname.startsWith("Win")) {
            this.windir = new File(System.getenv("windir"));
            this.systemroot = new File(System.getenv("systemroot"));
            this.tempdir = new File(System.getenv("TMP"));
            this.env = new String[]{"TMP=" + this.tempdir.getPath(), "TS_HOME=" + this.tshome.getPath(), "JAVA_HOME=" + this.javahome.getPath(), "ANT_HOME=" + this.anthome.getPath(), "S1AS_HOME=" + this.j2eehome.getPath(), "SPS_HOME=" + spsHome, "windir=" + this.windir.getPath(), "SystemRoot=" + this.systemroot.getPath(), "ANT_OPTS=" + this.antopts, "RI_JAVA_HOME=" + this.rijava.getPath(), "PATH=" + this.javahome.getPath() + "\bin;" + System.getenv("PATH"), "deliverabledir=" + this.deliverabledir};
        } else {
            this.env = new String[]{"TS_HOME=" + this.tshome.getPath(), "JAVA_HOME=" + this.javahome.getPath(), "ANT_HOME=" + this.anthome.getPath(), "S1AS_HOME=" + this.j2eehome.getPath(), "SPS_HOME=" + spsHome, "ANT_OPTS=" + this.antopts, "RI_JAVA_HOME=" + this.rijava.getPath(), "PATH=" + this.javahome.getPath() + "/bin:" + System.getenv("PATH"), "deliverabledir=" + this.deliverabledir};
        }
    }

    private String mapTestArea(String testDir) {
        return testDir.replace(File.separatorChar, '_');
    }

    private void removeJaccLog() {
        File jaccLog = new File(this.j2eehome, "domains" + File.separator + "domain1" + File.separator + "logs" + File.separator + "jacc_log.txt");
        File jaccLogLock = new File(this.j2eehome, "domains" + File.separator + "domain1" + File.separator + "logs" + File.separator + "jacc_log.txt.lck");
        if (jaccLog.isFile()) {
            jaccLog.delete();
            this.log("Deleted JACC Log.", 2);
        }
        if (jaccLogLock.isFile()) {
            jaccLogLock.delete();
            this.log("Deleted JACC Log Lock.", 2);
        }
    }

    private void restartServer() throws Exception {
        this.restartServer("");
    }

    private String getPasswordArgs() {
        String result = null;
        result = this.is9 ? " --passwordfile " + this.passwordfile.getPath() : " --password " + this.password;
        return result;
    }

    private void restartServer(String testArea) throws Exception {
        if (this.remoteinstance) {
            String args = "--user " + this.username + this.getPasswordArgs() + " --host " + this.hostname + " --port " + this.adminport + " " + this.instancename;
            this.runAsadmin("stop-instance " + args);
            if (testArea.startsWith("jacc")) {
                this.removeJaccLog();
            }
            this.runAsadmin("start-instance " + args);
        } else {
            this.runAsadmin("stop-domain");
            if (testArea.startsWith("jacc")) {
                this.removeJaccLog();
            }
            this.runAsadmin("start-domain --user " + this.username + this.getPasswordArgs());
        }
    }

    private StringBuffer runAsadmin(String cmd) throws Exception {
        return this.runCommand(this.asadmin + " " + cmd, this.j2eehomebin, true, true);
    }

    private StringBuffer runTsant(String cmd, File dir) throws Exception {
        return this.runTsant(cmd, dir, true);
    }

    private StringBuffer runTsant(String cmd, File dir, boolean blocking) throws Exception {
        return this.runCommand(this.tsant + " " + cmd, dir, blocking, this.bufferingenabled);
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "").toUpperCase().startsWith("WIN");
    }

    private StringBuffer runCommand(String cmd, File dir, boolean blocking, boolean buffer) throws Exception {
        StringBuffer buf = new StringBuffer();
        int pstat = 0;
        try {
            Runtime rt = Runtime.getRuntime();
            if (this.isWindows()) {
                cmd = "cmd /c " + cmd;
            }
            this.log("Running ==> \"" + cmd + "\"", 2);
            this.proc = rt.exec(cmd, this.env, dir);
            this.errThread = new StreamWatcher(this.proc.getErrorStream(), this.project, "ERR", buffer);
            this.errThread.start();
            this.outThread = new StreamWatcher(this.proc.getInputStream(), this.project, "OUT", buffer);
            this.outThread.start();
            if (blocking) {
                pstat = this.proc.waitFor();
                this.errThread.join(this.jointimeout);
                this.outThread.join(this.jointimeout);
                buf = this.outThread.getBuffer();
            } else {
                this.procs.add(this.proc);
                this.threads.add(this.errThread);
                this.threads.add(this.outThread);
            }
            this.log("Proc status ==> \"" + pstat + "\"", 2);
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
            throw ex;
        }
        return buf;
    }

    public static class StreamWatcher
    extends Thread {
        private boolean buffering;
        private final String NL;
        private StringBuffer buf = new StringBuffer();
        private InputStream in;
        private String id;
        private Project project;

        public StreamWatcher(InputStream in, Project project, String id, boolean buffering) {
            this.in = in;
            this.project = project;
            this.id = id;
            this.buffering = buffering;
            this.NL = System.getProperty("line.separator", "\n");
        }

        public StringBuffer getBuffer() {
            return this.buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.project.log("Starting StreamWatcher for " + this.in, 3);
            BufferedReader breader = null;
            try {
                breader = new BufferedReader(new InputStreamReader(this.in));
                String line = breader.readLine();
                while (line != null) {
                    if (this.buffering) {
                        this.buf.append(line + this.NL);
                    }
                    System.err.println(this.id + " => " + line);
                    line = breader.readLine();
                    Thread.sleep(2L);
                }
                int index = this.buf.lastIndexOf(this.NL);
                if (index != -1 && this.buffering) {
                    this.buf = this.buf.delete(index, this.buf.length());
                }
            }
            catch (InterruptedException e) {
                this.project.log("Stream Watcher for \"" + this.id + "\" Stopping", 2);
            }
            catch (InterruptedIOException e) {
                this.project.log("Stream Watcher for \"" + this.id + "\" Stopping", 2);
            }
            catch (Exception e) {
                this.project.log("StreamWatcher error is " + e, 0);
            }
            finally {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (Exception e) {
                    this.project.log("StreamWatcher error closing input stream, exception is: " + e, 0);
                }
            }
        }
    }
}

