/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public abstract class TestFinder {
    private static final TestDescription[] noTests = new TestDescription[0];
    private static final File userDir = new File(System.getProperty("user.dir"));
    protected static boolean debug = Boolean.getBoolean("debug." + TestFinder.class.getName());
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestFinder.class);
    @Deprecated
    protected TestEnvironment env;
    private Map<String, String> keywordCache = new HashMap<String, String>();
    private File root;
    private File rootDir;
    private ErrorHandler errHandler;
    private Comparator<String> comp = TestFinder.getDefaultComparator();
    private List<File> files;
    private List<TestDescription> tests;
    private Map<String, Integer> testsInFile = new HashMap<String, Integer>();
    private List<String> errorMessages = new ArrayList<String>();

    protected static Comparator<String> getDefaultComparator() {
        Collator c = Collator.getInstance(Locale.US);
        c.setStrength(0);
        return c::compare;
    }

    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws Fault {
        if (args != null) {
            this.decodeAllArgs(args);
        }
        this.setRoot(testSuiteRoot);
        this.env = env;
    }

    @Deprecated
    public void init(String[] args, File testSuiteRoot, File[] tests, TestFilter[] filters, TestEnvironment env) throws Fault {
        this.init(args, testSuiteRoot, env);
    }

    protected void decodeAllArgs(String ... args) throws Fault {
        int j;
        for (int i = 0; i < args.length; i += j) {
            j = this.decodeArg(args, i);
            if (j != 0) continue;
            throw new Fault(i18n, "finder.badArg", (Object)args[i]);
        }
    }

    protected int decodeArg(String[] args, int i) throws Fault {
        return 0;
    }

    public File getRoot() {
        return this.root;
    }

    protected void setRoot(File testSuiteRoot) throws Fault {
        if (this.root != null) {
            throw new IllegalStateException("root already set");
        }
        this.root = testSuiteRoot.isAbsolute() ? testSuiteRoot : new File(userDir, testSuiteRoot.getPath());
        this.rootDir = this.root.isDirectory() ? this.root : new File(this.root.getParent());
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public Comparator<String> getComparator() {
        return this.comp;
    }

    public void setComparator(Comparator<String> c) {
        this.comp = c;
    }

    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public void setErrorHandler(ErrorHandler h) {
        this.errHandler = h;
    }

    protected void error(I18NResourceBundle i18n, String key) {
        this.localizedError(i18n.getString(key));
    }

    protected void error(I18NResourceBundle i18n, String key, Object arg) {
        this.localizedError(i18n.getString(key, arg));
    }

    protected void error(I18NResourceBundle i18n, String key, Object ... args) {
        this.localizedError(i18n.getString(key, args));
    }

    protected void localizedError(String msg) {
        this.errorMessages.add(msg);
        if (this.errHandler != null) {
            this.errHandler.error(msg);
        }
    }

    public synchronized int getErrorCount() {
        return this.errorMessages.size();
    }

    public synchronized String[] getErrors() {
        return this.errorMessages.toArray(new String[this.errorMessages.size()]);
    }

    public synchronized void clearErrors() {
        this.errorMessages.clear();
    }

    public boolean isFolder(File path) {
        if (!path.isAbsolute()) {
            File f = new File(this.getRoot(), path.getPath());
            return f.isDirectory();
        }
        return path.isDirectory();
    }

    public long lastModified(File f) {
        if (f.isAbsolute()) {
            return f.lastModified();
        }
        File real = new File(this.getRoot(), f.getPath());
        return real.lastModified();
    }

    public synchronized void read(File file) {
        if (this.tests != null) {
            this.tests.clear();
        }
        if (this.files != null) {
            this.files.clear();
        }
        this.testsInFile.clear();
        this.scan(file.isAbsolute() ? file : new File(this.rootDir, file.getPath()));
    }

    protected abstract void scan(File var1);

    protected void processEntry(Map<String, String> entries, String name, String value) {
        if ((name = name.intern()).equalsIgnoreCase("keywords")) {
            String keywordCacheValue = this.keywordCache.get(value);
            if (keywordCacheValue == null) {
                String lv = value.toLowerCase();
                Object[] lvs = StringArray.split(lv);
                Arrays.sort(lvs);
                keywordCacheValue = StringArray.join((String[])lvs).intern();
                this.keywordCache.put(value, keywordCacheValue);
            }
            value = keywordCacheValue;
        } else {
            value = value.intern();
        }
        entries.put(name, value);
    }

    protected Map<String, String> normalize(Map<String, String> entries) {
        return entries;
    }

    protected void foundTestDescription(Map<String, String> entries, File file, int line) {
        String rru;
        Integer prevLine;
        String id;
        entries = this.normalize(entries);
        if (debug) {
            System.err.println("Found TestDescription");
            System.err.println("--------values----------------------------");
            for (String key : entries.keySet()) {
                System.err.println(">> " + key + ": " + entries.get(key));
            }
            System.err.println("------------------------------------------");
        }
        if ((id = entries.get("id")) == null) {
            id = "";
        }
        if ((prevLine = this.testsInFile.get(id)) != null) {
            String newId;
            int i = 1;
            while (this.testsInFile.get(newId = id + "__" + i) != null) {
                ++i;
            }
            this.error(i18n, "finder.nonUniqueId", file, id.isEmpty() ? "(unset)" : id, line, prevLine, newId);
            id = newId;
            entries.put("id", id);
        }
        this.testsInFile.put(id, line);
        TestDescription td = new TestDescription(this.root, file, entries);
        if (this.errHandler != null && (rru = td.getRootRelativeURL()).indexOf(32) != -1) {
            this.error(i18n, "finder.spaceInId", (Object)td.getRootRelativeURL());
        }
        this.foundTestDescription(td);
    }

    protected void foundTestDescription(TestDescription td) {
        if (debug) {
            System.err.println("Found TestDescription" + td.getName());
        }
        if (this.tests == null) {
            this.tests = new ArrayList<TestDescription>();
        }
        int target = 0;
        if (this.tests.isEmpty()) {
            target = 0;
        } else if (this.comp == null) {
            target = this.tests.size();
        } else {
            int left = 0;
            int right = this.tests.size() - 1;
            int center = 0;
            String name = td.getName();
            while (left < right) {
                center = (right + left) / 2;
                int cmp = this.comp.compare(name, this.tests.get(center).getName());
                if (cmp < 0) {
                    right = center;
                    continue;
                }
                if (cmp < 0) continue;
                left = center + 1;
            }
            target = this.comp.compare(name, this.tests.get(left).getName()) > 0 ? left + 1 : left;
        }
        this.tests.add(target, td);
    }

    public TestDescription[] getTests() {
        if (this.tests == null) {
            return noTests;
        }
        return this.tests.toArray(new TestDescription[this.tests.size()]);
    }

    public Optional<Integer> totalNumberOfTestsInTheSuite() {
        return Optional.empty();
    }

    protected void foundFile(File newFile) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        int target = 0;
        if (this.files.isEmpty()) {
            target = 0;
        } else if (this.comp == null) {
            target = this.files.size();
        } else {
            int left = 0;
            int right = this.files.size() - 1;
            int center = 0;
            String path = newFile.getPath();
            while (left < right) {
                center = (right + left) / 2;
                int cmp = this.comp.compare(path, this.files.get(center).getPath());
                if (cmp < 0) {
                    right = center;
                    continue;
                }
                if (cmp < 0) continue;
                left = center + 1;
            }
            target = this.comp.compare(path, this.files.get(left).getPath()) > 0 ? left + 1 : left;
        }
        this.files.add(target, newFile);
    }

    public File[] getFiles() {
        if (this.files == null) {
            return new File[0];
        }
        return this.files.toArray(new File[this.files.size()]);
    }

    public static class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18n, String msgKey) {
            super(i18n.getString(msgKey));
        }

        public Fault(I18NResourceBundle i18n, String msgKey, Object arg) {
            super(i18n.getString(msgKey, arg));
        }

        public Fault(I18NResourceBundle i18n, String msgKey, Object ... args) {
            super(i18n.getString(msgKey, args));
        }
    }

    public static interface ErrorHandler {
        public void error(String var1);
    }
}

