/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CopyOnWriteTextStore;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;
import org.eclipse.mylyn.docs.intent.serializer.IntentSerializer;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;
import org.eclipse.swt.widgets.Display;

public class IntentEditorDocument
extends AbstractDocument
implements IDocument {
    public static final String MODELING_PREFIX_DECORATION = "\n";
    public static final String MODELING_SUFFIX_DECORATION = "\n";
    private EObject ast;
    private IntentSerializer serializer = new IntentSerializer("\n", "\n");
    private IntentEditor associatedEditor;

    public IntentEditorDocument(IntentEditor editor) {
        this.associatedEditor = editor;
        this.setTextStore((ITextStore)new CopyOnWriteTextStore((ITextStore)new GapTextStore()));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
    }

    public IntentEditorDocument(EObject root, IntentEditor editor) {
        this.associatedEditor = editor;
        this.ast = root;
        this.setTextStore((ITextStore)new CopyOnWriteTextStore((ITextStore)new GapTextStore()));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.set(this.serializer.serialize(root));
    }

    public void set(String text) {
        super.set(text);
    }

    public Object getAST() {
        return this.ast;
    }

    public void setAST(EObject newAST) {
        this.ast = newAST;
    }

    public void replace(int pos, int length, String text) throws BadLocationException {
        super.replace(pos, length, text);
    }

    private IntentPositionManager getPositionManager() {
        return this.serializer.getPositionManager();
    }

    public void setSerializer(IntentSerializer serializer) {
        this.serializer = serializer;
    }

    public void reloadFromAST() {
        this.reloadFromAST(false);
    }

    protected void reloadFromAST(boolean syncExec) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (IntentEditorDocument.this.associatedEditor.getSelectionProvider() != null) {
                    ISelection selection = IntentEditorDocument.this.associatedEditor.getSelectionProvider().getSelection();
                    try {
                        String serializedForm = IntentEditorDocument.this.serializer.serialize(IntentEditorDocument.this.ast);
                        if (!IntentEditorDocument.this.get().equals(serializedForm)) {
                            IntentEditorDocument.this.replace(0, IntentEditorDocument.this.getLength(), serializedForm);
                        }
                    }
                    catch (BadLocationException e) {
                        IntentUiLogger.logError("Error encountered while refreshing the document ", e);
                    }
                    IntentEditorDocument.this.associatedEditor.getSelectionProvider().setSelection(selection);
                }
            }
        };
        if (syncExec) {
            Display.getDefault().syncExec(runnable);
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public ParsedElementPosition getIntentPosition(EObject element) {
        ParsedElementPosition positionForElement = this.getPositionManager().getPositionForElement(element);
        if (element instanceof ExternalContentReference) {
            try {
                int lineID = this.getLineOfOffset(positionForElement.getOffset());
                int followingLineLength = this.getLineLength(lineID + 1);
                positionForElement.setLength(positionForElement.getDeclarationLength() + followingLineLength - 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        return positionForElement;
    }

    public EObject getElementAtOffset(int offset) {
        return this.getPositionManager().getElementAtPosition(offset);
    }

    public void unsynchronize() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IntentEditorDocument.this.set("The opened elements are out of sync. (have been deleted by another user. )");
            }
        });
    }

    public IntentEditor getIntentEditor() {
        return this.associatedEditor;
    }
}

