/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.completion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.mylyn.docs.intent.client.ui.editor.completion.AbstractIntentCompletionProcessor;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupCompletionProcessor
extends AbstractIntentCompletionProcessor {
    public MarkupCompletionProcessor(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    @Override
    protected ICompletionProposal[] computeCompletionProposals() {
        ArrayList proposals = Lists.newArrayList();
        String documentText = this.document.get().substring(0, this.offset);
        int i = documentText.length() - 1;
        ArrayList<Character> lastRelevantChar = new ArrayList<Character>();
        while (i > 2) {
            Character relevantChar = Character.valueOf(documentText.charAt(i));
            --i;
            if (relevantChar.charValue() == '\n') break;
            if (!this.isRelevantChar(relevantChar.charValue())) continue;
            if (lastRelevantChar.contains(relevantChar)) {
                lastRelevantChar.remove(relevantChar);
                continue;
            }
            lastRelevantChar.add(relevantChar);
        }
        char relevantChar = '\n';
        if (!lastRelevantChar.isEmpty()) {
            relevantChar = ((Character)lastRelevantChar.iterator().next()).charValue();
        }
        this.addProposal(proposals, relevantChar, "Emphasis", "_");
        this.addProposal(proposals, relevantChar, "Strong", "*");
        this.addProposal(proposals, relevantChar, "Image", "!", "imagePath", true);
        this.addProposal(proposals, relevantChar, "List (buletted)", "*", "", false);
        this.addProposal(proposals, relevantChar, "List (numeric)", "#", "", false);
        this.addProposal(proposals, relevantChar, "Code", "@");
        this.addProposal(proposals, relevantChar, "Italic", "__ ");
        this.addProposal(proposals, relevantChar, "Bold", "** ");
        this.addProposal(proposals, relevantChar, "List (level 2, buletted)", "** ", "", false);
        this.addProposal(proposals, relevantChar, "List (level 2, numeric)", "## ", "", false);
        this.addProposal(proposals, relevantChar, "Citation", "??");
        this.addProposal(proposals, relevantChar, "Deleted", "-");
        this.addProposal(proposals, relevantChar, "Inserted", "+");
        this.addProposal(proposals, relevantChar, "Superscript", "^");
        this.addProposal(proposals, relevantChar, "Span", "%");
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private boolean isRelevantChar(char currentChar) {
        return currentChar == '_' || currentChar == '@' || currentChar == '*' || currentChar == '%' || currentChar == '+' || currentChar == '^' || currentChar == '-' || currentChar == '#' || currentChar == '!' || currentChar == '?';
    }

    private void addProposal(Collection<ICompletionProposal> proposals, char relevantChar, String fontDecorationName, String fontDecorationSyntax) {
        this.addProposal(proposals, relevantChar, fontDecorationName, fontDecorationSyntax, "", true);
    }

    private void addProposal(Collection<ICompletionProposal> proposals, char relevantChar, String fontDecorationName, String fontDecorationSyntax, String variableName, boolean biDirectionalSyntax) {
        if (relevantChar == '\n') {
            proposals.add(this.createFontDecorationProposal(fontDecorationName, fontDecorationSyntax, variableName, biDirectionalSyntax));
        } else if (biDirectionalSyntax && fontDecorationSyntax.charAt(0) == relevantChar) {
            String currenText = this.document.get().substring(0, this.offset);
            currenText = currenText.substring(currenText.lastIndexOf(relevantChar));
            proposals.add(this.createFontDecorationProposal(fontDecorationName, fontDecorationSyntax, variableName, currenText));
        }
    }

    @Override
    public String getContextType() {
        return "__dftl_partition_content_type";
    }

    private ICompletionProposal createFontDecorationProposal(String fontDecorationName, String fontDecorationSyntax, String variableName, boolean biDirectionalSyntax) {
        String templateName = "";
        String templatePattern = "";
        if (biDirectionalSyntax) {
            templateName = String.valueOf(fontDecorationSyntax) + fontDecorationName.toLowerCase() + fontDecorationSyntax;
            templatePattern = String.valueOf(fontDecorationSyntax) + "${ " + variableName + "}" + fontDecorationSyntax;
        } else {
            templateName = String.valueOf(fontDecorationSyntax) + " " + fontDecorationName.toLowerCase();
            templatePattern = String.valueOf(fontDecorationSyntax) + " ${ " + variableName + "}";
        }
        return this.createTemplateProposal(templateName, fontDecorationName, templatePattern, null);
    }

    private ICompletionProposal createFontDecorationProposal(String fontDecorationName, String fontDecorationSyntax, String variableName, String beginningText) {
        String templateName = String.valueOf(fontDecorationSyntax) + fontDecorationName.toLowerCase() + fontDecorationSyntax;
        String templatePattern = "";
        if (beginningText.contains(" ")) {
            beginningText = beginningText.substring(beginningText.lastIndexOf(32)).trim();
        }
        if (beginningText.contains(fontDecorationSyntax) && !this.isSkipped(fontDecorationSyntax.charAt(0))) {
            beginningText = beginningText.substring(beginningText.lastIndexOf(fontDecorationSyntax.charAt(0)) + fontDecorationSyntax.length()).trim();
        }
        templatePattern = String.valueOf(beginningText) + fontDecorationSyntax;
        return this.createTemplateProposal(templateName, fontDecorationName, templatePattern, null);
    }

    private boolean isSkipped(char currentChar) {
        return currentChar == '_' || currentChar == '@';
    }
}

