/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.bridge.java.listeners;

import java.util.Set;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.docs.intent.bridge.java.util.JavaBridgeUtils;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.synchronizer.api.contribution.ISynchronizerExtension;
import org.eclipse.mylyn.docs.intent.client.ui.ide.generatedelementlistener.IDEGeneratedElementListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaElementListener
extends IDEGeneratedElementListener
implements ISynchronizerExtension,
IResourceChangeListener {
    public boolean isExtensionFor(URI uri) {
        return JavaBridgeUtils.isHandledByJavaBridge(uri);
    }

    public void addListenedElements(SynchronizerRepositoryClient synchronizerClient, Set<URI> listenedElementsURIs) {
        this.synchronizer = synchronizerClient;
        for (URI listenedElementURI : listenedElementsURIs) {
            this.addElementToListen(this.transformToJavaURI(listenedElementURI));
        }
    }

    public void removeListenedElements(SynchronizerRepositoryClient synchronizer, Set<URI> listenedElementsURIs) {
        for (URI listenedElementURI : listenedElementsURIs) {
            this.removeElementToListen(this.transformToJavaURI(listenedElementURI));
        }
    }

    private URI transformToJavaURI(URI listenedElementURI) {
        URI javaFileURI = URI.createPlatformResourceURI((String)listenedElementURI.toString(), (boolean)false).trimFragment();
        String javaClassURI = javaFileURI.toString().replace("src", "bin");
        if (javaClassURI.lastIndexOf(".java") != -1) {
            javaClassURI = String.valueOf(javaClassURI.substring(0, javaClassURI.length() - 5)) + ".class";
        }
        return URI.createURI((String)javaClassURI);
    }
}

