/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.utils;

import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.Arrays;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.markup.markup.Annotations;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;

public final class IntentPrettyPrinter {
    private static final String QUOTE = "\"";
    private static final String WHITESPACE = " ";
    private static final String SEP = " |";
    private static final int COLUMN_LENGTH = 40;

    private IntentPrettyPrinter() {
    }

    public static void printComparison(Comparison comparison, PrintStream stream) {
        for (MatchResource res : comparison.getMatchedResources()) {
            stream.println("Matched resources :");
            stream.println("Left = " + res.getLeftURI());
            stream.println("Right = " + res.getRightURI());
            stream.println("origin = " + res.getOriginURI());
        }
        stream.println();
        IntentPrettyPrinter.printMatch(comparison, stream);
        stream.println();
        IntentPrettyPrinter.printDifferences(comparison, stream);
    }

    public static void printMatch(Comparison comparison, PrintStream stream) {
        stream.println("+----------------------------------------+----------------------------------------+----------------------------------------+");
        stream.println(String.valueOf('|') + IntentPrettyPrinter.formatHeader("Left") + '|' + IntentPrettyPrinter.formatHeader("Right") + '|' + IntentPrettyPrinter.formatHeader("Origin") + '|');
        stream.println("+----------------------------------------+----------------------------------------+----------------------------------------+");
        for (Match match : comparison.getMatches()) {
            IntentPrettyPrinter.printMatch(match, stream);
        }
        stream.println("+----------------------------------------+----------------------------------------+----------------------------------------+");
    }

    public static void printDifferences(Comparison comparison, PrintStream stream) {
        Iterable refChanges = Iterables.filter((Iterable)comparison.getDifferences(), ReferenceChange.class);
        stream.println("REFERENCE CHANGES");
        for (Diff diff : refChanges) {
            IntentPrettyPrinter.printDiff(diff, stream);
        }
        stream.println();
        stream.println("ATTRIBUTE CHANGES");
        Iterable attChanges = Iterables.filter((Iterable)comparison.getDifferences(), AttributeChange.class);
        for (Diff diff : attChanges) {
            IntentPrettyPrinter.printDiff(diff, stream);
        }
        stream.println();
        stream.println("CONFLICTS");
        for (Conflict conflict : comparison.getConflicts()) {
            IntentPrettyPrinter.printConflict(conflict, stream);
        }
    }

    private static void printConflict(Conflict conflict, PrintStream stream) {
        stream.println(conflict.getKind() + " conflict:");
        Iterable refChanges = Iterables.filter((Iterable)conflict.getDifferences(), ReferenceChange.class);
        for (Diff diff : refChanges) {
            stream.print("\t");
            IntentPrettyPrinter.printDiff(diff, stream);
        }
        Iterable attChanges = Iterables.filter((Iterable)conflict.getDifferences(), AttributeChange.class);
        for (Diff diff : attChanges) {
            stream.print("\t");
            IntentPrettyPrinter.printDiff(diff, stream);
        }
    }

    private static void printDiff(Diff diff, PrintStream stream) {
        if (diff instanceof ReferenceChange) {
            ReferenceChange refChange = (ReferenceChange)diff;
            String valueName = refChange.getValue() != null ? IntentPrettyPrinter.elementToReadableString(refChange.getValue()) : refChange.getValue().toString();
            String change = "";
            if (diff.getSource() == DifferenceSource.RIGHT) {
                change = "remotely ";
            }
            change = diff.getKind() == DifferenceKind.ADD ? String.valueOf(change) + "added to" : (diff.getKind() == DifferenceKind.DELETE ? String.valueOf(change) + "deleted from" : (diff.getKind() == DifferenceKind.CHANGE ? String.valueOf(change) + "changed from" : String.valueOf(change) + "moved from"));
            String objectName = refChange.getMatch().getLeft() != null ? IntentPrettyPrinter.elementToReadableString(refChange.getMatch().getLeft()) : (refChange.getMatch().getRight() != null ? IntentPrettyPrinter.elementToReadableString(refChange.getMatch().getRight()) : (refChange.getMatch().getOrigin() != null ? IntentPrettyPrinter.elementToReadableString(refChange.getMatch().getOrigin()) : ""));
            if (valueName != null) {
                stream.println("[" + diff.getKind() + "] " + "value " + valueName + " has been " + change + " reference " + refChange.getReference().getName() + " of object " + objectName);
            }
        } else if (diff instanceof AttributeChange) {
            AttributeChange attChange = (AttributeChange)diff;
            String valueName = "null";
            if (attChange.getValue() != null) {
                valueName = attChange.getValue().toString();
            }
            String change = "";
            if (diff.getSource() == DifferenceSource.RIGHT) {
                change = "remotely ";
            }
            change = diff.getKind() == DifferenceKind.ADD ? String.valueOf(change) + "added to" : (diff.getKind() == DifferenceKind.DELETE ? String.valueOf(change) + "deleted from" : (diff.getKind() == DifferenceKind.CHANGE ? String.valueOf(change) + "changed from" : String.valueOf(change) + "moved from"));
            String objectName = attChange.getMatch().getLeft() != null ? IntentPrettyPrinter.elementToReadableString(attChange.getMatch().getLeft()) : (attChange.getMatch().getRight() != null ? IntentPrettyPrinter.elementToReadableString(attChange.getMatch().getRight()) : (attChange.getMatch().getOrigin() != null ? IntentPrettyPrinter.elementToReadableString(attChange.getMatch().getOrigin()) : ""));
            stream.println("value " + valueName + " has been " + change + " attribute " + attChange.getAttribute().getName() + " of object " + objectName);
        }
    }

    private static void printMatch(Match match, PrintStream stream) {
        Match currentMatch;
        int level;
        String leftName = null;
        String rightName = null;
        EObject left = match.getLeft();
        EObject right = match.getRight();
        if (left != null) {
            leftName = IntentPrettyPrinter.formatName(left);
        } else {
            level = 0;
            currentMatch = match;
            while (currentMatch instanceof Match && currentMatch.getLeft() == null) {
                currentMatch = currentMatch.eContainer();
            }
            while (currentMatch instanceof Match && currentMatch.getLeft() != null) {
                ++level;
                currentMatch = currentMatch.eContainer();
            }
            leftName = IntentPrettyPrinter.getEmptyLine(level);
        }
        if (right != null) {
            rightName = IntentPrettyPrinter.formatName(right);
        } else {
            level = 0;
            currentMatch = match;
            while (currentMatch instanceof Match && currentMatch.getRight() == null) {
                currentMatch = currentMatch.eContainer();
            }
            while (currentMatch instanceof Match && currentMatch.getRight() != null) {
                ++level;
                currentMatch = currentMatch.eContainer();
            }
            rightName = IntentPrettyPrinter.getEmptyLine(level);
        }
        if (leftName != null && rightName != null) {
            stream.println(String.valueOf('|') + leftName + '|' + rightName + '|');
        }
        for (Match submatch : match.getSubmatches()) {
            IntentPrettyPrinter.printMatch(submatch, stream);
        }
    }

    private static String formatHeader(String header) {
        int padding = (40 - header.length()) / 2;
        char[] charsBefore = new char[padding];
        int i = 0;
        while (i < charsBefore.length) {
            charsBefore[i] = 32;
            ++i;
        }
        if ((header.length() & 1) == 1) {
            ++padding;
        }
        char[] charsAfter = new char[padding];
        int i2 = 0;
        while (i2 < charsAfter.length) {
            charsAfter[i2] = 32;
            ++i2;
        }
        return String.valueOf(String.valueOf(charsBefore)) + header + String.valueOf(charsAfter);
    }

    private static String formatName(EObject element) {
        String name = IntentPrettyPrinter.elementToReadableString(element);
        if (name != null) {
            int level = 0;
            EObject current = element;
            while (current.eContainer() != null) {
                ++level;
                current = current.eContainer();
            }
            char[] charsBefore = new char[1 + level * 2];
            charsBefore[0] = 32;
            if (level > 0) {
                int i = 1;
                while (i < charsBefore.length - 2) {
                    charsBefore[i] = 124;
                    charsBefore[i + 1] = 32;
                    i += 2;
                }
                charsBefore[charsBefore.length - 2] = 124;
                charsBefore[charsBefore.length - 1] = 45;
            }
            int missingChars = 40 - name.length() - charsBefore.length;
            char[] spacesAfter = new char[Math.max(0, missingChars)];
            Arrays.fill(spacesAfter, ' ');
            return String.valueOf(String.valueOf(charsBefore)) + name + String.valueOf(spacesAfter);
        }
        return null;
    }

    private static String getEmptyLine(int level) {
        char[] charsBefore = new char[1 + level * 2];
        charsBefore[0] = 32;
        int i = 1;
        while (i < charsBefore.length) {
            charsBefore[i] = 124;
            charsBefore[i + 1] = 32;
            i += 2;
        }
        int missingChars = 40 - charsBefore.length;
        char[] spacesAfter = new char[Math.max(0, missingChars)];
        Arrays.fill(spacesAfter, ' ');
        return String.valueOf(String.valueOf(charsBefore)) + String.valueOf(spacesAfter);
    }

    public static void displayModel(EObject root) {
        IntentPrettyPrinter.displayModel(root, "");
    }

    public static void displayModel(EObject root, String tab) {
        String s = IntentPrettyPrinter.elementToReadableString(root);
        if (s != null) {
            System.out.println(String.valueOf(tab) + "-" + s);
        }
        for (EObject content : root.eContents()) {
            if (root instanceof IntentDocument) {
                IntentPrettyPrinter.displayModel(content, tab);
                continue;
            }
            IntentPrettyPrinter.displayModel(content, String.valueOf(tab) + SEP);
        }
    }

    public static void displayMatchModel(Comparison comparison) {
        for (Match root : comparison.getMatches()) {
            IntentPrettyPrinter.displayMatchModel(root, "");
        }
    }

    private static void displayMatchModel(Match root, String tab) {
        String matchString = IntentPrettyPrinter.matchToReadableString(root);
        if (matchString != null) {
            System.out.println(String.valueOf(tab) + "-" + matchString);
        }
        for (Match match : root.getSubmatches()) {
            if (root.getLeft() instanceof IntentDocument) {
                IntentPrettyPrinter.displayMatchModel(match, tab);
                continue;
            }
            IntentPrettyPrinter.displayMatchModel(match, String.valueOf(tab) + SEP);
        }
    }

    public static String diffToReadableString(Diff diff) {
        String res = diff.getKind() + WHITESPACE;
        if (diff instanceof AttributeChange) {
            AttributeChange change = (AttributeChange)diff;
            res = String.valueOf(res) + change.getAttribute().getEContainingClass().getName() + "." + change.getAttribute().getName() + WHITESPACE;
        } else if (diff instanceof ReferenceChange) {
            ReferenceChange change = (ReferenceChange)diff;
            res = String.valueOf(res) + change.getReference().getEContainingClass().getName() + "." + change.getReference().getName() + WHITESPACE;
        }
        res = String.valueOf(res) + "\n" + diff + "\n";
        res = String.valueOf(res) + "based on " + IntentPrettyPrinter.matchToReadableString(diff.getMatch());
        return res;
    }

    private static String matchToReadableString(Match match) {
        String res = null;
        String left = IntentPrettyPrinter.elementToReadableString(match.getLeft());
        String right = IntentPrettyPrinter.elementToReadableString(match.getRight());
        if (left != null && right != null) {
            res = String.valueOf(left) + " == " + right;
        }
        return res;
    }

    public static String elementToReadableString(EObject element) {
        String res = null;
        res = element == null ? "?" : element.eClass().getName();
        if (element instanceof Text) {
            res = QUOTE + ((Text)element).getData() + QUOTE;
        } else if (element instanceof IntentDocument || element instanceof Annotations) {
            res = null;
        } else if (element instanceof StructuralFeatureAffectation) {
            StructuralFeatureAffectation aff = (StructuralFeatureAffectation)element;
            res = String.valueOf(res) + element.eClass().getName() + " \"" + aff.getName() + QUOTE;
        }
        return res;
    }
}

