/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class ArrayUtil {
    public static boolean contains(Object[] a, Object o) {
        return ArrayUtil.indexOf(a, o) >= 0;
    }

    public static int indexOf(Object[] a, Object o) {
        return ArrayUtil.indexOfMatching(a, e -> Objects.equals(e, o));
    }

    public static int lastIndexOf(Object[] a, Object o) {
        return ArrayUtil.lastIndexOfMatching(a, e -> Objects.equals(e, o));
    }

    public static <T> boolean containsMatching(T[] a, Predicate<? super T> p) {
        return ArrayUtil.indexOfMatching(a, p) >= 0;
    }

    public static <T> int indexOfMatching(T[] a, Predicate<? super T> p) {
        int i = 0;
        int len = a.length;
        while (i < len) {
            if (p.test(a[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int lastIndexOfMatching(T[] a, Predicate<? super T> p) {
        int i = a.length - 1;
        while (i >= 0) {
            if (p.test(a[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static <T, C extends Collection<? super T>> C collectMatching(T[] a, Predicate<? super T> p, C c) {
        T[] TArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (p.test(t)) {
                c.add(t);
            }
            ++n2;
        }
        return c;
    }

    @SafeVarargs
    public static <T> List<T> elementsOfType(Object[] a, Class<? extends T> ... types) {
        ArrayList list = new ArrayList();
        ArrayUtil.collectMatching(a, new TypePredicate(types), list);
        ArrayList result = list;
        return result;
    }

    public static boolean hasElementsOfType(Object[] a, Class<?> ... types) {
        return ArrayUtil.containsMatching(a, new TypePredicate(types));
    }

    public static boolean hasElementsNotOfType(Object[] a, Class<?> ... types) {
        return ArrayUtil.containsMatching(a, new TypePredicate(types).negate());
    }

    public static boolean hasOnlyElementsOfType(Object[] a, Class<?> ... types) {
        return !ArrayUtil.hasElementsNotOfType(a, types);
    }

    public static <T> List<T> concat(T[] a, Collection<? extends T> b) {
        ArrayList<T> list = new ArrayList<T>(Arrays.asList(a));
        list.addAll(b);
        return list;
    }

    public static <T> Set<T> union(T[] a, Collection<? extends T> b) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(Arrays.asList(a));
        set.addAll(b);
        return set;
    }

    public static <T> Set<T> setMinus(T[] a, Collection<?> b) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(Arrays.asList(a));
        set.removeAll(b);
        return set;
    }

    private ArrayUtil() {
    }

    private static class TypePredicate
    implements Predicate<Object> {
        private final Class<?>[] types;

        TypePredicate(Class<?> ... types) {
            if (types.length == 0) {
                throw new IllegalArgumentException("At least one type is required");
            }
            this.types = types;
        }

        @Override
        public boolean test(Object obj) {
            Class<?>[] classArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> t = classArray[n2];
                if (t.isInstance(obj)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

