/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.field;

import org.aspectj.org.eclipse.jdt.internal.core.nd.INdStruct;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.BaseField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IRefCountedField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;

public class FieldOneToOne<T extends INdStruct>
extends BaseField
implements IDestructableField,
IRefCountedField {
    public final StructDef<T> nodeType;
    FieldOneToOne<?> backPointer;
    private boolean pointsToOwner;
    private final ModificationLog.Tag putTag;
    private final ModificationLog.Tag destructTag;

    private FieldOneToOne(StructDef<T> nodeType, FieldOneToOne<?> backPointer, boolean pointsToOwner) {
        this.nodeType = nodeType;
        if (backPointer != null) {
            if (backPointer.backPointer != null && backPointer.backPointer != this) {
                throw new IllegalArgumentException("Attempted to construct a FieldOneToOne referring to a backpointer list that is already in use by another field");
            }
            backPointer.backPointer = this;
        }
        this.backPointer = backPointer;
        this.pointsToOwner = pointsToOwner;
        this.setFieldName("field " + nodeType.getNumFields() + ", a " + this.getClass().getSimpleName() + " in struct " + nodeType.getStructName());
        this.putTag = ModificationLog.createTag("Writing " + this.getFieldName());
        this.destructTag = ModificationLog.createTag("Destructing " + this.getFieldName());
    }

    public static <T extends INdStruct, B extends INdStruct> FieldOneToOne<T> create(StructDef<B> builder, StructDef<T> nodeType, FieldOneToOne<B> forwardPointer) {
        FieldOneToOne<T> result = new FieldOneToOne<T>(nodeType, forwardPointer, false);
        builder.add(result);
        builder.addDestructableField(result);
        return result;
    }

    public static <T extends INdStruct, B extends INdStruct> FieldOneToOne<T> createOwner(StructDef<B> builder, StructDef<T> nodeType, FieldOneToOne<B> forwardPointer) {
        FieldOneToOne<T> result = new FieldOneToOne<T>(nodeType, forwardPointer, true);
        builder.add(result);
        builder.addDestructableField(result);
        builder.addOwnerField(result);
        return result;
    }

    public T get(Nd nd, long address) {
        long ptr = nd.getDB().getRecPtr(address + (long)this.offset);
        return NdNode.load(nd, ptr, this.nodeType);
    }

    public void put(Nd nd, long address, T target) {
        Database db = nd.getDB();
        db.getLog().start(this.putTag);
        try {
            this.cleanup(nd, address);
            if (target == null) {
                db.putRecPtr(address + (long)this.offset, 0L);
                if (this.pointsToOwner) {
                    nd.scheduleDeletion(address);
                }
            } else {
                db.putRecPtr(address + (long)this.offset, target.getAddress());
                db.putRecPtr(target.getAddress() + (long)this.backPointer.offset, address);
            }
        }
        finally {
            db.getLog().end(this.putTag);
        }
    }

    @Override
    public void destruct(Nd nd, long address) {
        Database db = nd.getDB();
        db.getLog().start(this.destructTag);
        try {
            this.cleanup(nd, address);
        }
        finally {
            db.getLog().end(this.destructTag);
        }
    }

    private void cleanup(Nd nd, long address) {
        Database db = nd.getDB();
        long ptr = db.getRecPtr(address + (long)this.offset);
        if (ptr != 0L) {
            db.putRecPtr(ptr + (long)this.backPointer.offset, 0L);
            if (this.backPointer.pointsToOwner) {
                nd.scheduleDeletion(ptr);
            }
        }
    }

    @Override
    public int getRecordSize() {
        return 4;
    }

    @Override
    public boolean hasReferences(Nd nd, long address) {
        if (this.pointsToOwner) {
            long ptr = nd.getDB().getRecPtr(address + (long)this.offset);
            return ptr != 0L;
        }
        return false;
    }
}

