/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AdviceKind;

public class Proceed
extends MessageSend {
    public boolean inInner = false;

    public Proceed(MessageSend parent) {
        this.receiver = parent.receiver;
        this.selector = parent.selector;
        this.arguments = parent.arguments;
        this.binding = parent.binding;
        this.syntheticAccessor = parent.syntheticAccessor;
        this.expectedType = parent.expectedType;
        this.nameSourcePosition = parent.nameSourcePosition;
        this.actualReceiverType = parent.actualReceiverType;
        this.valueCast = parent.valueCast;
        this.typeArguments = parent.typeArguments;
        this.genericTypeArguments = parent.genericTypeArguments;
        this.sourceStart = parent.sourceStart;
        this.sourceEnd = parent.sourceEnd;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        AdviceDeclaration aroundDecl = this.findEnclosingAround(scope);
        if (aroundDecl == null) {
            return super.resolveType(scope);
        }
        this.constant = Constant.NotAConstant;
        this.binding = aroundDecl.proceedMethodBinding;
        this.actualReceiverType = this.binding.declaringClass;
        int baseArgCount = 0;
        if (this.arguments != null) {
            baseArgCount = this.arguments.length;
            Expression[] newArguments = new Expression[baseArgCount + 1];
            System.arraycopy(this.arguments, 0, newArguments, 0, baseArgCount);
            this.arguments = newArguments;
        } else {
            this.arguments = new Expression[1];
        }
        this.arguments[baseArgCount] = AstUtil.makeLocalVariableReference(aroundDecl.extraArgument.binding);
        int declaredParameterCount = aroundDecl.getDeclaredParameterCount();
        if (baseArgCount < declaredParameterCount) {
            scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "too few arguments to proceed, expected " + declaredParameterCount);
            aroundDecl.ignoreFurtherInvestigation = true;
            return null;
        }
        if (baseArgCount > declaredParameterCount) {
            scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "too many arguments to proceed, expected " + declaredParameterCount);
            aroundDecl.ignoreFurtherInvestigation = true;
            return null;
        }
        boolean argsContainCast = false;
        for (int i = 0; i < this.arguments.length; ++i) {
            if (!(this.arguments[i] instanceof CastExpression)) continue;
            argsContainCast = true;
        }
        int len = this.arguments.length;
        this.argumentTypes = len == 0 ? TypeBinding.NO_TYPES : new TypeBinding[len];
        for (int i = 0; i < len; ++i) {
            TypeBinding paramType;
            Expression arg = this.arguments[i];
            this.argumentTypes[i] = arg.resolveType(scope);
            if (this.argumentTypes[i] == null || this.argumentTypes[i].isCompatibleWith(paramType = this.binding.parameters[i])) continue;
            scope.problemReporter().typeMismatchError(this.argumentTypes[i], paramType, arg, null);
        }
        Proceed.checkInvocationArguments(scope, null, this.actualReceiverType, this.binding, this.arguments, this.binding.parameters, argsContainCast, this);
        this.resolvedType = this.binding.returnType;
        return this.binding.returnType;
    }

    private AdviceDeclaration findEnclosingAround(Scope scope) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof MethodScope) {
            MethodScope methodScope = (MethodScope)scope;
            ReferenceContext context = methodScope.referenceContext;
            if (context instanceof AdviceDeclaration) {
                AdviceDeclaration adviceDecl = (AdviceDeclaration)context;
                if (adviceDecl.kind == AdviceKind.Around) {
                    if (this.receiver != null && !this.receiver.isThis()) {
                        return null;
                    }
                    adviceDecl.proceedCalls.add(this);
                    return adviceDecl;
                }
                return null;
            }
        } else if (scope instanceof ClassScope) {
            this.inInner = true;
        }
        return this.findEnclosingAround(scope.parent);
    }
}

