/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler;

import java.lang.reflect.Modifier;
import org.aspectj.ajdt.internal.compiler.CommonPrinter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;

class ITDMethodPrinter
extends CommonPrinter {
    private InterTypeMethodDeclaration methodDeclaration;

    ITDMethodPrinter(InterTypeMethodDeclaration methodDeclaration, MethodScope methodscope) {
        super(methodscope);
        this.output = new StringBuilder();
        this.methodDeclaration = methodDeclaration;
        this.declaration = methodDeclaration;
    }

    public String print() {
        return this.print(2);
    }

    public StringBuilder printReturnType(int indent) {
        if (this.methodDeclaration.returnType == null) {
            return this.output;
        }
        return this.printExpression(this.methodDeclaration.returnType).append(' ');
    }

    public String print(int tab) {
        int i;
        this.output = new StringBuilder();
        if (this.methodDeclaration.javadoc != null) {
            // empty if block
        }
        this.printIndent(tab);
        if (this.methodDeclaration.annotations != null) {
            this.printAnnotations(this.methodDeclaration.annotations);
        }
        this.printModifiers(this.methodDeclaration.declaredModifiers);
        TypeParameter[] typeParams = this.methodDeclaration.typeParameters();
        if (typeParams != null) {
            this.output.append('<');
            int max = typeParams.length - 1;
            for (int j = 0; j < max; ++j) {
                this.printTypeParameter(typeParams[j]);
                this.output.append(", ");
            }
            this.printTypeParameter(typeParams[max]);
            this.output.append("> ");
        }
        this.printReturnType(0).append(this.methodDeclaration.getDeclaredSelector()).append('(');
        if (this.methodDeclaration.arguments != null) {
            int n = i = Modifier.isStatic(this.methodDeclaration.declaredModifiers) ? 0 : 1;
            while (i < this.methodDeclaration.arguments.length) {
                this.printArgument(this.methodDeclaration.arguments[i]);
                if (i + 1 < this.methodDeclaration.arguments.length) {
                    this.output.append(", ");
                }
                ++i;
            }
        }
        this.output.append(')');
        if (this.methodDeclaration.thrownExceptions != null) {
            this.output.append(" throws ");
            for (i = 0; i < this.methodDeclaration.thrownExceptions.length; ++i) {
                if (i > 0) {
                    this.output.append(", ");
                }
                this.printTypeReference(this.methodDeclaration.thrownExceptions[i]);
            }
        }
        this.printBody(tab + 1);
        return this.output.toString();
    }
}

