/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.ExponentialDistribution;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class GammaDistribution
extends RealDistribution {
    private final CifRandomGenerator randGen;
    private final double a;
    private final double b;

    public GammaDistribution(CifRandomGenerator randGen, double a, double b) {
        this.randGen = randGen;
        this.a = a;
        this.b = b;
        if (a <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The shape parameter (the first parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
        if (b <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The scale parameter (the second parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private GammaDistribution(GammaDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.a = distribution.a;
        this.b = distribution.b;
    }

    @Override
    public RealDistribution copy() {
        return new GammaDistribution(this);
    }

    @Override
    public double sample() {
        return GammaDistribution.sample(this.randGen, this.a, this.b);
    }

    public static double sample(CifRandomGenerator randGen, double a, double b) {
        double y;
        double z;
        double w;
        double shape = a;
        double scale = b;
        if (shape < 1.0) {
            double y2;
            double v;
            double w2;
            double beta = (Math.E + shape) / Math.E;
            do {
                w2 = beta * randGen.draw();
                v = randGen.draw();
            } while (!(w2 < 1.0 ? v <= Math.exp(-(y2 = Math.pow(w2, 1.0 / shape))) : v <= Math.pow(y2 = -Math.log((beta - w2) / shape), shape - 1.0)));
            return scale * y2;
        }
        if (shape == 1.0) {
            return ExponentialDistribution.sample(randGen, scale);
        }
        double alpha = 1.0 / Math.sqrt(2.0 * shape - 1.0);
        double beta = shape - Math.log(4.0);
        double gamma = shape + 1.0 / alpha;
        double delta = 1.0 + Math.log(4.5);
        do {
            double u1;
            double v;
            if (!((w = beta + gamma * (v = alpha * Math.log((u1 = randGen.drawNonZero()) / (1.0 - u1))) - (y = shape * Math.exp(v))) + delta - 4.5 * (z = u1 * u1 * randGen.drawNonZero()) >= 0.0)) continue;
            return scale * y;
        } while (!(w >= Math.log(z)));
        return scale * y;
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"gamma(%s, %s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.a), CifSimulatorMath.realToStr(this.b)});
    }
}

