//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2010, 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.bdd.conversion.bitvectors;

import static org.eclipse.escet.common.java.Strings.fmt;

import com.github.javabdd.BDD;

/**
 * A {@link BddBitVector} and a carry {@link BDD}.
 *
 * @param <T> The type of BDD bit vector.
 * @param <TC> The type of BDD bit vector and carry.
 */
public abstract class BddBitVectorAndCarry<T extends BddBitVector<T, TC>, TC extends BddBitVectorAndCarry<T, TC>> {
    /** The BDD bit vector. */
    public final T vector;

    /** The carry bit as BDD. */
    public final BDD carry;

    /**
     * Constructor for the {@link BddBitVectorAndCarry} class.
     *
     * @param vector The BDD bit vector.
     * @param carry The carry bit as BDD.
     */
    public BddBitVectorAndCarry(T vector, BDD carry) {
        this.vector = vector;
        this.carry = carry;
    }

    @Override
    public String toString() {
        return fmt("(%s, %s)", vector, carry);
    }
}
