/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class CodePointReader {
    private final Reader reader;
    private int buffer;
    private boolean bufferAvailable = false;

    public CodePointReader(InputStream stream) {
        this(stream, "UTF-8", true);
    }

    public CodePointReader(InputStream stream, String encoding) {
        this(stream, encoding, true);
    }

    public CodePointReader(InputStream stream, boolean buffered) {
        this(stream, "UTF-8", buffered);
    }

    public CodePointReader(InputStream stream, String encoding, boolean buffered) {
        this(CodePointReader.readerForStream(stream, encoding), buffered);
    }

    public CodePointReader(Reader reader) {
        this(reader, true);
    }

    public CodePointReader(Reader reader, boolean buffered) {
        if (buffered) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
    }

    private static Reader readerForStream(InputStream stream, String encoding) {
        try {
            return new InputStreamReader(stream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid encoding.", e);
        }
    }

    public int read() throws IOException {
        int c1;
        if (this.bufferAvailable) {
            c1 = this.buffer;
            this.bufferAvailable = false;
        } else {
            c1 = this.reader.read();
        }
        if (Character.isHighSurrogate((char)c1)) {
            int c2 = this.reader.read();
            if (Character.isLowSurrogate((char)c2)) {
                return Character.toCodePoint((char)c1, (char)c2);
            }
            this.buffer = c2;
            this.bufferAvailable = true;
        }
        return c1;
    }
}

