/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;

public class TupleTypeCodeGenerator {
    private TupleTypeCodeGenerator() {
    }

    public static void gencodeTupleType(TupleType tupleType, String className, CifCompilerContext ctxt) {
        Field field;
        JavaCodeFile file = ctxt.addCodeFile(className);
        CodeBox h = file.header;
        h.add("/** Tuple type \"%s\". */", new Object[]{CifTextUtils.typeToStr((CifType)tupleType)});
        h.add("public final class %s implements RuntimeToStringable {", new Object[]{className});
        CodeBox c = file.body;
        EList fields = tupleType.getFields();
        List names = Lists.listc((int)fields.size());
        int i = 0;
        while (i < fields.size()) {
            field = (Field)fields.get(i);
            names.add(ctxt.getTupleTypeFieldFieldName(field));
            ++i;
        }
        i = 0;
        while (i < fields.size()) {
            field = (Field)fields.get(i);
            c.add("public %s %s;", new Object[]{TypeCodeGenerator.gencodeType(field.getType(), ctxt), names.get(i)});
            ++i;
        }
        List paramTxts = Lists.listc((int)fields.size());
        int i2 = 0;
        while (i2 < fields.size()) {
            Field field2 = (Field)fields.get(i2);
            String typeTxt = TypeCodeGenerator.gencodeType(field2.getType(), ctxt);
            paramTxts.add(typeTxt + " " + (String)names.get(i2));
            ++i2;
        }
        c.add();
        c.add("public %s(%s) {", new Object[]{className, String.join((CharSequence)", ", paramTxts)});
        c.indent();
        for (String name : names) {
            c.add("this.%s = %s;", new Object[]{name, name});
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("public %s copy() {", new Object[]{className});
        c.indent();
        c.add("return new %s(%s);", new Object[]{className, String.join((CharSequence)", ", names)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public int hashCode() {");
        c.indent();
        i = 0;
        while (i < fields.size()) {
            c.add("%s hash(%s)%s", new Object[]{i == 0 ? "return" : "      ", names.get(i), i == fields.size() - 1 ? ";" : " ^"});
            ++i;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public boolean equals(Object obj) {");
        c.indent();
        c.add("if (this == obj) return true;");
        c.add("%s other = (%s)obj;", new Object[]{className, className});
        i = 0;
        while (i < fields.size()) {
            String fieldName = (String)names.get(i);
            c.add("%s equal(this.%s, other.%s)%s", new Object[]{i == 0 ? "return" : "      ", fieldName, fieldName, i == fields.size() - 1 ? ";" : " &&"});
            ++i;
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String toString() {");
        c.indent();
        c.add("StringBuilder rslt = new StringBuilder();");
        c.add("rslt.append(\"(\");");
        i = 0;
        while (i < names.size() - 1) {
            c.add("rslt.append(runtimeToString(%s));", new Object[]{names.get(i)});
            c.add("rslt.append(\", \");");
            ++i;
        }
        c.add("rslt.append(runtimeToString(%s));", new Object[]{Lists.last((List)names)});
        c.add("rslt.append(\")\");");
        c.add("return rslt.toString();");
        c.dedent();
        c.add("}");
        TupleTypeCodeGenerator.genPopMethod(tupleType, className, ctxt, c);
    }

    public static void genPopMethod(TupleType tupleType, String className, CifCompilerContext ctxt, CodeBox c) {
        CifType netype1;
        if (tupleType.getFields().size() != 2) {
            return;
        }
        Field field1 = (Field)tupleType.getFields().get(1);
        CifType ntype1 = CifTypeUtils.normalizeType((CifType)field1.getType());
        if (!(ntype1 instanceof ListType)) {
            return;
        }
        Field field0 = (Field)tupleType.getFields().get(0);
        CifType ntype0 = CifTypeUtils.normalizeType((CifType)field0.getType());
        boolean typeMatch = CifTypeUtils.checkTypeCompat((CifType)ntype0, (CifType)(netype1 = CifTypeUtils.normalizeType((CifType)((ListType)ntype1).getElementType())), (RangeCompat)RangeCompat.IGNORE);
        if (!typeMatch) {
            return;
        }
        c.add();
        c.add("public static %s pop(List<%s> lst) {", new Object[]{className, TypeCodeGenerator.gencodeType(ntype0, ctxt, true)});
        c.indent();
        c.add("if (lst.isEmpty()) {");
        c.indent();
        c.add("String msg = \"Invalid operation: pop([]).\";");
        c.add("throw new CifSimulatorException(msg);");
        c.dedent();
        c.add("}");
        c.add("return new %s(lst.get(0), slice(lst, 1, null));", new Object[]{className});
        c.dedent();
        c.add("}");
    }
}

