/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.atmp.ImageBuilder;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.abel.DisplayPositionned;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.anim.AnimationDecoder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.DisplaySection;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.ColorOrder;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.skin.SkinParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleLoader;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public abstract class TitledDiagram
extends AbstractPSystem
implements Diagram,
Annotated {
    public static boolean FORCE_SMETANA = false;
    public static boolean FORCE_ELK = false;
    private DisplayPositioned title = DisplayPositioned.none(HorizontalAlignment.CENTER, VerticalAlignment.TOP);
    private DisplayPositioned caption = DisplayPositioned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositioned legend = DisplayPositioned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private final DisplaySection header = DisplaySection.none();
    private final DisplaySection footer = DisplaySection.none();
    private Display mainFrame;
    private final UmlDiagramType type;
    private final SkinParam skinParam;
    private Animation animation;
    private final Pragma pragma = new Pragma();
    private boolean useSmetana;
    private boolean useElk;

    public Pragma getPragma() {
        return this.pragma;
    }

    public TitledDiagram(UmlSource source, UmlDiagramType type, Map<String, String> orig) {
        super(source);
        this.type = type;
        this.skinParam = SkinParam.create(type);
        if (orig != null) {
            this.skinParam.copyAllFrom(orig);
        }
    }

    public final StyleBuilder getCurrentStyleBuilder() {
        return this.skinParam.getCurrentStyleBuilder();
    }

    public final UmlDiagramType getUmlDiagramType() {
        return this.type;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String key, String value) {
        this.skinParam.setParam(StringUtils.goLowerCase(key), value);
    }

    public void addSprite(String name, Sprite sprite) {
        this.skinParam.addSprite(name, sprite);
    }

    public CommandExecutionResult loadSkin(String newSkin) throws IOException {
        String filename = newSkin + ".skin";
        InputStream is = StyleLoader.getInputStreamForStyle(filename);
        if (is == null) {
            return CommandExecutionResult.error("Cannot find style " + newSkin);
        }
        is.close();
        this.getSkinParam().setDefaultSkin(filename);
        return CommandExecutionResult.ok();
    }

    public final void setTitle(DisplayPositioned title) {
        if (title.isNull() || title.getDisplay().isWhite()) {
            return;
        }
        this.title = title;
    }

    @Override
    public final DisplayPositionned getTitle() {
        return this.title;
    }

    @Override
    public final Display getTitleDisplay() {
        if (this.title == null) {
            return null;
        }
        return this.title.getDisplay();
    }

    public final void setMainFrame(Display mainFrame) {
        this.mainFrame = mainFrame;
    }

    public final void setCaption(DisplayPositioned caption) {
        this.caption = caption;
    }

    @Override
    public final DisplayPositioned getCaption() {
        return this.caption;
    }

    @Override
    public final DisplaySection getHeader() {
        return this.header;
    }

    @Override
    public final DisplaySection getFooter() {
        return this.footer;
    }

    @Override
    public final DisplayPositioned getLegend() {
        return this.legend;
    }

    public void setLegend(DisplayPositioned legend) {
        this.legend = legend;
    }

    @Override
    public final Display getMainFrame() {
        return this.mainFrame;
    }

    public void setUseSmetana(boolean useSmetana) {
        this.useSmetana = useSmetana;
    }

    public void setUseElk(boolean useElk) {
        this.useElk = useElk;
    }

    public boolean isUseElk() {
        if (FORCE_ELK) {
            return true;
        }
        return this.useElk;
    }

    public boolean isUseSmetana() {
        if (FORCE_SMETANA) {
            return true;
        }
        return this.useSmetana;
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.same(10.0);
    }

    public final void setAnimation(Iterable<CharSequence> animationData) {
        AnimationDecoder animationDecoder = new AnimationDecoder(animationData);
        this.animation = Animation.create(animationDecoder.decode());
    }

    public final Animation getAnimation() {
        return this.animation;
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return super.createImageBuilder(fileFormatOption).styled(this);
    }

    public HColor calculateBackColor() {
        Style style = StyleSignatureBasic.of(SName.root, SName.document, this.getUmlDiagramType().getStyleName()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        if (backgroundColor == null) {
            backgroundColor = HColors.transparent();
        }
        return backgroundColor;
    }

    @Override
    protected ColorMapper muteColorMapper(ColorMapper init) {
        if ("dark".equalsIgnoreCase(this.getSkinParam().getValue("mode"))) {
            return ColorMapper.DARK_MODE;
        }
        String monochrome = this.getSkinParam().getValue("monochrome");
        if ("true".equals(monochrome)) {
            return ColorMapper.MONOCHROME;
        }
        if ("reverse".equals(monochrome)) {
            return ColorMapper.MONOCHROME_REVERSE;
        }
        String reversecolor = this.getSkinParam().getValue("reversecolor");
        if (reversecolor == null) {
            return init;
        }
        if ("dark".equalsIgnoreCase(reversecolor)) {
            return ColorMapper.LIGTHNESS_INVERSE;
        }
        ColorOrder order = ColorOrder.fromString(reversecolor);
        if (order == null) {
            return init;
        }
        return ColorMapper.reverse(order);
    }

    protected abstract TextBlock getTextBlock();

    @Override
    public void exportDiagramGraphic(UGraphic ug) {
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(ug);
    }
}

