/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.json;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.epsilon.common.util.FileUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.json.Contained;
import org.eclipse.epsilon.emc.json.HasCreatorModel;
import org.eclipse.epsilon.emc.json.JsonModelArray;
import org.eclipse.epsilon.emc.json.JsonModelObject;
import org.eclipse.epsilon.emc.json.JsonPropertyGetter;
import org.eclipse.epsilon.emc.json.JsonPropertySetter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.json.simple.JSONValue;

public class JsonModel
extends CachedModel<Object> {
    public static final String JSON_ARRAY_TYPE = "JSONArray";
    public static final String JSON_OBJECT_TYPE = "JSONObject";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_URI = "uri";
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_HEADER_PREFIX = "header";
    public static final char PROPERTY_HEADER_SEPARATOR = ':';
    protected File file;
    protected String uri;
    protected String username;
    protected String password;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Object _root;

    public JsonModel() {
        this.propertyGetter = new JsonPropertyGetter();
        this.propertySetter = new JsonPropertySetter();
    }

    public Object getRoot() {
        return this._root;
    }

    public void setRoot(Object root) {
        if (this._root == root) {
            return;
        }
        if (this._root instanceof Contained) {
            ((Contained)this._root).removeContainer((Object)this);
        }
        this._root = root;
        if (this._root instanceof Contained) {
            ((Contained)this._root).addContainer((Object)this);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        throw new UnsupportedOperationException();
    }

    public String getTypeNameOf(Object instance) {
        if (instance instanceof JsonModelObject) {
            return JSON_OBJECT_TYPE;
        }
        if (instance instanceof JsonModelArray) {
            return JSON_ARRAY_TYPE;
        }
        return instance.getClass().getSimpleName();
    }

    public Object getElementById(String id) {
        throw new UnsupportedOperationException();
    }

    public String getElementId(Object instance) {
        throw new UnsupportedOperationException();
    }

    public void setElementId(Object instance, String newId) {
        throw new UnsupportedOperationException();
    }

    public boolean owns(Object instance) {
        if (instance instanceof Contained) {
            Contained contained = (Contained)instance;
            if (contained.isContainedBy((Object)this)) {
                return true;
            }
            if (contained.getContainers().isEmpty() && contained instanceof HasCreatorModel) {
                return ((HasCreatorModel)((Object)contained)).getCreatorModel() == this;
            }
        }
        return instance instanceof Contained && ((Contained)instance).isContainedBy((Object)this);
    }

    public boolean isInstantiable(String type) {
        return this.hasType(type);
    }

    public boolean hasType(String type) {
        return JSON_OBJECT_TYPE.equals(type) || JSON_ARRAY_TYPE.equals(type);
    }

    public boolean store(String location) {
        try {
            FileUtil.setFileContents((String)JSONValue.toJSONString((Object)this.getRoot()), (File)new File(location));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean store() {
        if (this.file != null) {
            return this.store(this.file.getAbsolutePath());
        }
        throw new UnsupportedOperationException();
    }

    protected Collection<Object> allContentsFromModel() {
        ArrayList<Object> objects = new ArrayList<Object>();
        this.addAllContents(this.getRoot(), objects, o -> o instanceof JsonModelObject || o instanceof JsonModelArray);
        return objects;
    }

    private void addAllContents(Object current, List<Object> objects, Predicate<Object> addFilter) {
        block4: {
            block3: {
                if (addFilter.test(current)) {
                    objects.add(current);
                }
                if (!(current instanceof JsonModelObject)) break block3;
                for (Object value : ((JsonModelObject)current).values()) {
                    this.addAllContents(value, objects, addFilter);
                }
                break block4;
            }
            if (!(current instanceof JsonModelArray)) break block4;
            for (Object child : (JsonModelArray)current) {
                this.addAllContents(child, objects, addFilter);
            }
        }
    }

    protected Collection<Object> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (JSON_OBJECT_TYPE.equals(type)) {
            this.addAllContents(this.getRoot(), objects, o -> o instanceof JsonModelObject);
        } else if (JSON_ARRAY_TYPE.equals(type)) {
            this.addAllContents(this.getRoot(), objects, o -> o instanceof JsonModelArray);
        } else {
            throw new EolModelElementTypeNotFoundException(this.getName(), type);
        }
        return objects;
    }

    protected Collection<Object> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        return this.getAllOfTypeFromModel(kind);
    }

    protected Object createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (JSON_OBJECT_TYPE.equals(type)) {
            return new JsonModelObject(this);
        }
        if (JSON_ARRAY_TYPE.equals(type)) {
            return new JsonModelArray(this);
        }
        throw new EolModelElementTypeNotFoundException(this.getName(), type);
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        String filePath = properties.getProperty(PROPERTY_FILE);
        if (filePath != null && filePath.trim().length() > 0) {
            this.file = new File(resolver.resolve(filePath));
        } else {
            this.uri = properties.getProperty(PROPERTY_URI);
            this.username = properties.getProperty(PROPERTY_USERNAME);
            this.password = properties.getProperty(PROPERTY_PASSWORD);
            for (Map.Entry e : properties.entrySet()) {
                if (!e.getKey().toString().startsWith(PROPERTY_HEADER_PREFIX)) continue;
                String nameValue = e.getValue().toString();
                int firstColon = nameValue.indexOf(58);
                if (firstColon == -1) {
                    throw new IllegalArgumentException(String.format("Could not find separator '%s' in value of header property %s", Character.valueOf(':'), e.getKey()));
                }
                String name = nameValue.substring(0, firstColon).trim();
                String value = nameValue.substring(firstColon + 1).trim();
                this.headers.put(name, value);
            }
        }
        this.load();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadModel() throws EolModelLoadingException {
        if (!this.readOnLoad) {
            return;
        }
        try {
            if (this.uri != null) {
                URI parsedUri = new URI(this.uri);
                if ("http".equals(parsedUri.getScheme()) || "https".equals(parsedUri.getScheme())) {
                    this.loadModelViaHTTP(parsedUri);
                    return;
                }
                Throwable throwable = null;
                Object var3_9 = null;
                try {
                    InputStream is = parsedUri.toURL().openStream();
                    try {
                        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                            this.setRoot(JsonModel.deepClone(JSONValue.parse((Reader)reader)));
                        }
                        if (is == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            if (this.file == null) throw new IllegalStateException("Neither URI nor file path have been set");
            Throwable parsedUri = null;
            Object var2_7 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8);){
                this.setRoot(JsonModel.deepClone(JSONValue.parse((Reader)reader)));
                return;
            }
            catch (Throwable throwable) {
                if (parsedUri == null) {
                    parsedUri = throwable;
                    throw parsedUri;
                } else {
                    if (parsedUri == throwable) throw parsedUri;
                    parsedUri.addSuppressed(throwable);
                }
                throw parsedUri;
            }
        }
        catch (Exception ex) {
            throw new EolModelLoadingException(ex, (IModel)this);
        }
    }

    private void loadModelViaHTTP(URI parsedUri) throws IOException, ClientProtocolException, EolRuntimeException {
        HttpClientBuilder builder = HttpClients.custom();
        if (this.username != null) {
            BasicCredentialsProvider creds = new BasicCredentialsProvider();
            creds.setCredentials(new AuthScope(parsedUri.getHost(), parsedUri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)creds);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpClient httpClient = builder.build();){
            HttpGet httpGet = new HttpGet(this.uri);
            for (Map.Entry<String, String> e : this.headers.entrySet()) {
                httpGet.setHeader(e.getKey(), e.getValue());
            }
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new EolRuntimeException(String.format("HTTP request to %s returned a non-200 status code: %d", this.uri, httpResponse.getStatusLine().getStatusCode()));
            }
            HttpEntity responseEntity = httpResponse.getEntity();
            InputStreamReader reader = new InputStreamReader(responseEntity.getContent(), StandardCharsets.UTF_8);
            this.setRoot(JsonModel.deepClone(JSONValue.parse((Reader)reader)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Object deepClone(Object parsed) {
        if (parsed instanceof Map) {
            JsonModelObject obj = new JsonModelObject();
            for (Map.Entry e : ((Map)parsed).entrySet()) {
                obj.put((String)e.getKey(), JsonModel.deepClone(e.getValue()));
            }
            return obj;
        }
        if (parsed instanceof Iterable) {
            JsonModelArray arr = new JsonModelArray();
            for (Object e : (Iterable)parsed) {
                arr.add(JsonModel.deepClone(e));
            }
            return arr;
        }
        return parsed;
    }

    protected void disposeModel() {
        this.setRoot(null);
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        throw new UnsupportedOperationException();
    }

    protected Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return type;
    }

    protected Collection<String> getAllTypeNamesOf(Object instance) {
        return Collections.singleton(this.getTypeNameOf(instance));
    }

    public boolean isLoaded() {
        return this.getRoot() != null;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String toString() {
        return "JsonModel [name=" + this.name + "]";
    }

    public void setJsonContent(String s) {
        this.setRoot(JsonModel.deepClone(JSONValue.parse((String)s)));
    }
}

