/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.rdf.emf;

import java.util.List;
import org.apache.jena.rdf.model.Resource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.epsilon.rdf.emf.IDisableable;
import org.eclipse.epsilon.rdf.emf.RDFGraphResourceImpl;
import org.eclipse.epsilon.rdf.emf.RDFGraphResourceUpdate;

public class RDFGraphResourceNotificationAdapterChangeRDF
extends EContentAdapter
implements IDisableable {
    private boolean isDisabled = false;
    private final RDFGraphResourceImpl initialRDFGraphResource;

    public RDFGraphResourceNotificationAdapterChangeRDF(RDFGraphResourceImpl rdfGraphResource) {
        this.initialRDFGraphResource = rdfGraphResource;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    private RDFGraphResourceImpl getGraphResourceForEObject(EObject eObject) {
        RDFGraphResourceImpl graphResource = (RDFGraphResourceImpl)eObject.eResource();
        if (graphResource == null) {
            graphResource = this.initialRDFGraphResource;
        }
        return graphResource;
    }

    private List<Resource> getNamedModelsToUpdate(EObject eObject, RDFGraphResourceImpl graphResource) {
        List<Resource> namedModelResources = graphResource.getResourcesForNamedModelsContaining(eObject);
        if (!namedModelResources.isEmpty()) {
            return namedModelResources;
        }
        namedModelResources = graphResource.getResourcesForAllNamedModels();
        if (!namedModelResources.isEmpty()) {
            Resource first = namedModelResources.get(0);
            namedModelResources.clear();
            namedModelResources.add(first);
            return namedModelResources;
        }
        System.err.println("no model resource?");
        return null;
    }

    public void notifyChanged(Notification notification) {
        if (!this.isDisabled) {
            Object feature = notification.getFeature();
            if (feature != null) {
                this.featureNotification(feature, notification);
            } else {
                this.handleNonFeatureNotification(notification.getNewValue(), notification);
                this.handleNonFeatureNotification(notification.getOldValue(), notification);
            }
        }
        super.notifyChanged(notification);
    }

    private void handleNonFeatureNotification(Object value, Notification notification) {
        if (value instanceof EObject) {
            this.handleEObjectAttachOrDetach(notification, (EObject)value);
        }
        if (value instanceof List) {
            for (Object o : (List)value) {
                if (!(o instanceof EObject)) continue;
                this.handleEObjectAttachOrDetach(notification, (EObject)o);
            }
        }
    }

    protected void handleEObjectAttachOrDetach(Notification notification, EObject eObjectValue) {
        RDFGraphResourceImpl graphResource = this.getGraphResourceForEObject(eObjectValue);
        switch (notification.getEventType()) {
            case 3: 
            case 5: {
                graphResource.ensureGraphExists();
                RDFGraphResourceUpdate rdfUpdater = graphResource.getRDFGraphUpdater();
                for (Resource namedModelResource : this.getNamedModelsToUpdate(eObjectValue, graphResource)) {
                    rdfUpdater.addToResource(eObjectValue, graphResource.getNamedModel(namedModelResource));
                }
                break;
            }
            case 4: 
            case 6: {
                graphResource.ensureGraphExists();
                RDFGraphResourceUpdate rdfUpdater = graphResource.getRDFGraphUpdater();
                for (Resource namedModelResource : this.getNamedModelsToUpdate(eObjectValue, graphResource)) {
                    rdfUpdater.removeFromResource(eObjectValue, graphResource.getNamedModel(namedModelResource));
                }
                break;
            }
        }
    }

    private void featureNotification(Object feature, Notification notification) {
        if (feature instanceof EStructuralFeature) {
            this.eStructuralFeatureNotification((EStructuralFeature)feature, notification);
        } else {
            System.err.printf("unhandled additive change : %s\n", feature.getClass().getName());
        }
    }

    private void eStructuralFeatureNotification(EStructuralFeature eStructuralFeature, Notification notification) {
        EObject onEObject = (EObject)notification.getNotifier();
        EStructuralFeature changedFeature = eStructuralFeature;
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        int position = notification.getPosition();
        RDFGraphResourceImpl graphResource = (RDFGraphResourceImpl)onEObject.eResource();
        if (graphResource == null) {
            System.err.println("The Graph resource has been removed, using the initial graph resource instead");
            graphResource = this.initialRDFGraphResource;
        }
        RDFGraphResourceUpdate rdfUpdater = graphResource.getRDFGraphUpdater();
        List<Resource> namedModelURIs = graphResource.getResourcesForNamedModelsContaining(onEObject);
        switch (notification.getEventType()) {
            case 3: 
            case 5: {
                rdfUpdater.addMultiValueEStructuralFeature(namedModelURIs, onEObject, changedFeature, newValue, oldValue, position);
                break;
            }
            case 1: {
                if (oldValue == null) {
                    if (newValue == null) break;
                    namedModelURIs = graphResource.getResourcesForNamedModelsContaining(onEObject);
                    if (namedModelURIs.isEmpty() && !(namedModelURIs = graphResource.getResourcesForAllNamedModels()).isEmpty()) {
                        Resource first = namedModelURIs.get(0);
                        namedModelURIs.clear();
                        namedModelURIs.add(first);
                    }
                    rdfUpdater.addSingleValueEStructuralFeatureStatements(namedModelURIs, onEObject, changedFeature, newValue);
                    break;
                }
                if (newValue == null) {
                    namedModelURIs = graphResource.getResourcesForNamedModelsContaining(onEObject);
                    rdfUpdater.removeSingleValueEStructuralFeatureStatements(namedModelURIs, onEObject, changedFeature, notification.getOldValue());
                    break;
                }
                namedModelURIs = graphResource.getResourcesForNamedModelsContaining(onEObject);
                rdfUpdater.updateSingleValueEStructuralFeatureStatements(namedModelURIs, onEObject, changedFeature, newValue, oldValue);
                break;
            }
            case 4: 
            case 6: {
                rdfUpdater.removeMultiEStructuralFeature(namedModelURIs, onEObject, changedFeature, oldValue);
                break;
            }
            case 2: {
                namedModelURIs = graphResource.getResourcesForNamedModelsContaining(onEObject);
                rdfUpdater.removeSingleValueEStructuralFeatureStatements(namedModelURIs, onEObject, changedFeature, notification.getOldValue());
                break;
            }
        }
    }
}

