/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.NoSuchElementException;
import org.roaringbitmap.InvalidRoaringFormat;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class ImmutableRoaringArray
implements PointableRoaringArray {
    protected static final short SERIAL_COOKIE = 12347;
    protected static final short SERIAL_COOKIE_NO_RUNCONTAINER = 12346;
    private static final int startofrunbitmap = 4;
    ByteBuffer buffer;
    int size;

    protected ImmutableRoaringArray(ByteBuffer bbf) {
        boolean hasRunContainers;
        this.buffer = bbf.slice();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int cookie = this.buffer.getInt(0);
        boolean bl = hasRunContainers = (cookie & 0xFFFF) == 12347;
        if (!hasRunContainers && cookie != 12346) {
            throw new InvalidRoaringFormat("I failed to find one of the right cookies. " + cookie);
        }
        this.size = hasRunContainers ? (cookie >>> 16) + 1 : this.buffer.getInt(4);
        this.buffer.limit(this.computeSerializedSizeInBytes(hasRunContainers));
    }

    @Override
    public int advanceUntil(char x, int pos) {
        int upper;
        int lower = pos + 1;
        if (lower >= this.size || this.getKey(lower) >= x) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < this.size && this.getKey(lower + spansize) < x) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < this.size ? lower + spansize : this.size - 1;
        if (this.getKey(upper) == x) {
            return upper;
        }
        if (this.getKey(upper) < x) {
            return this.size;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (this.getKey(mid) == x) {
                return mid;
            }
            if (this.getKey(mid) < x) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    private int branchyUnsignedBinarySearch(char k) {
        int low = 0;
        int high = this.size - 1;
        char ikey = k;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = this.getKey(middleIndex);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    @Override
    public ImmutableRoaringArray clone() {
        ImmutableRoaringArray sa;
        try {
            sa = (ImmutableRoaringArray)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
        return sa;
    }

    private int computeSerializedSizeInBytes(boolean hasRunContainers) {
        int sizeOfLastContainer;
        if (this.size == 0) {
            return this.headerSize(hasRunContainers);
        }
        int positionOfLastContainer = this.getOffsetContainer(this.size - 1, hasRunContainers);
        if (this.isRunContainer(this.size - 1, hasRunContainers)) {
            char nbrruns = this.buffer.getChar(positionOfLastContainer);
            sizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinalityEtc(0, nbrruns, true);
        } else {
            int cardinalityOfLastContainer = this.getCardinality(this.size - 1);
            sizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinalityEtc(cardinalityOfLastContainer, 0, false);
        }
        return sizeOfLastContainer + positionOfLastContainer;
    }

    @Override
    public int getCardinality(int k) {
        if (k < 0 || k >= this.size) {
            throw new IllegalArgumentException("out of range container index: " + k + " (report as a bug)");
        }
        return this.buffer.getChar(this.getStartOfKeys() + 4 * k + 2) + '\u0001';
    }

    @Override
    public int getContainerIndex(char x) {
        return this.unsignedBinarySearch(x);
    }

    @Override
    public MappeableContainer getContainerAtIndex(int i) {
        boolean isBitmap;
        boolean hasrun = this.hasRunCompression();
        ByteBuffer tmp = this.buffer.duplicate();
        tmp.order(this.buffer.order());
        tmp.position(this.getOffsetContainer(i, hasrun));
        if (this.isRunContainer(i, hasrun)) {
            char nbrruns = tmp.getChar();
            CharBuffer charArray = tmp.asCharBuffer();
            charArray.limit(2 * nbrruns);
            return new MappeableRunContainer(charArray, (int)nbrruns);
        }
        int cardinality = this.getCardinality(i);
        boolean bl = isBitmap = cardinality > 4096;
        if (isBitmap) {
            LongBuffer bitmapArray = tmp.asLongBuffer();
            bitmapArray.limit(1024);
            return new MappeableBitmapContainer(bitmapArray, cardinality);
        }
        CharBuffer charArray = tmp.asCharBuffer();
        charArray.limit(cardinality);
        return new MappeableArrayContainer(charArray, cardinality);
    }

    @Override
    public boolean containsForContainerAtIndex(int i, char x) {
        boolean isBitmap;
        boolean hasrun = this.hasRunCompression();
        int containerpos = this.getOffsetContainer(i, hasrun);
        if (this.isRunContainer(i, hasrun)) {
            char nbrruns = this.buffer.getChar(containerpos);
            return MappeableRunContainer.contains(this.buffer, containerpos + 2, x, nbrruns);
        }
        int cardinality = this.getCardinality(i);
        boolean bl = isBitmap = cardinality > 4096;
        if (isBitmap) {
            return MappeableBitmapContainer.contains(this.buffer, containerpos, x);
        }
        return MappeableArrayContainer.contains(this.buffer, containerpos, x, cardinality);
    }

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return this.getContainerPointer(0);
    }

    @Override
    public MappeableContainerPointer getContainerPointer(final int startIndex) {
        final boolean hasrun = !this.isEmpty() && this.hasRunCompression();
        return new MappeableContainerPointer(){
            int k;
            final /* synthetic */ ImmutableRoaringArray this$0;
            {
                this.this$0 = this$0;
                this.k = startIndex;
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e2) {
                    return null;
                }
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return this.key() - o.key();
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return this.this$0.getCardinality(this.k);
            }

            @Override
            public MappeableContainer getContainer() {
                if (this.k >= this.this$0.size) {
                    return null;
                }
                return this.this$0.getContainerAtIndex(this.k);
            }

            @Override
            public int getSizeInBytes() {
                if (this.this$0.isRunContainer(this.k, hasrun)) {
                    int pos = this.this$0.getOffsetContainer(this.k, true);
                    char nbrruns = this.this$0.buffer.getChar(pos);
                    return BufferUtil.getSizeInBytesFromCardinalityEtc(0, nbrruns, true);
                }
                int CardinalityOfLastContainer = this.getCardinality();
                return BufferUtil.getSizeInBytesFromCardinalityEtc(CardinalityOfLastContainer, 0, false);
            }

            @Override
            public boolean hasContainer() {
                return 0 <= this.k && this.k < this.this$0.size;
            }

            @Override
            public boolean isBitmapContainer() {
                if (this.this$0.isRunContainer(this.k, hasrun)) {
                    return false;
                }
                return this.getCardinality() > 4096;
            }

            @Override
            public boolean isRunContainer() {
                return this.this$0.isRunContainer(this.k, hasrun);
            }

            @Override
            public char key() {
                return this.this$0.getKeyAtIndex(this.k);
            }

            @Override
            public void previous() {
                --this.k;
            }
        };
    }

    @Override
    public int getIndex(char x) {
        return this.unsignedBinarySearch(x);
    }

    private int getKey(int k) {
        return this.buffer.getChar(this.getStartOfKeys() + 4 * k);
    }

    @Override
    public char getKeyAtIndex(int i) {
        return this.buffer.getChar(4 * i + this.getStartOfKeys());
    }

    private int getOffsetContainer(int k, boolean hasRunCompression) {
        if (k < 0 || k >= this.size) {
            throw new IllegalArgumentException("out of range container index: " + k + " (report as a bug)");
        }
        if (hasRunCompression) {
            if (this.size < 4) {
                return this.getOffsetContainerSlow(k, true);
            }
            return this.buffer.getInt(4 + 4 * this.size + (this.size + 7) / 8 + 4 * k);
        }
        return this.buffer.getInt(8 + 4 * this.size + 4 * k);
    }

    private int getOffsetContainerSlow(int k, boolean hasRunCompression) {
        int pos = this.headerSize(hasRunCompression);
        for (int z = 0; z < k; ++z) {
            int sizeOfLastContainer;
            if (this.isRunContainer(z, hasRunCompression)) {
                char nbrruns = this.buffer.getChar(pos);
                sizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinalityEtc(0, nbrruns, true);
                pos += sizeOfLastContainer;
                continue;
            }
            int cardinalityOfLastContainer = this.getCardinality(z);
            sizeOfLastContainer = BufferUtil.getSizeInBytesFromCardinalityEtc(cardinalityOfLastContainer, 0, false);
            pos += sizeOfLastContainer;
        }
        return pos;
    }

    private int getStartOfKeys() {
        if (this.hasRunCompression()) {
            return 4 + (this.size + 7) / 8;
        }
        return 8;
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableRoaringArray) {
            ImmutableRoaringArray srb = (ImmutableRoaringArray)o;
            if (srb.size() != this.size()) {
                return false;
            }
            MappeableContainerPointer cp = this.getContainerPointer();
            MappeableContainerPointer cpo = srb.getContainerPointer();
            while (cp.hasContainer() && cpo.hasContainer()) {
                if (cp.key() != cpo.key()) {
                    return false;
                }
                if (cp.getContainer().equals(cpo.getContainer())) continue;
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        MappeableContainerPointer cp = this.getContainerPointer();
        int hashvalue = 0;
        while (cp.hasContainer()) {
            int th = cp.key() * 0xF0F0F0 + cp.getContainer().hashCode();
            hashvalue = 31 * hashvalue + th;
            cp.advance();
        }
        return hashvalue;
    }

    @Override
    public boolean hasRunCompression() {
        return (this.buffer.getInt(0) & 0xFFFF) == 12347;
    }

    protected int headerSize(boolean hasrun) {
        if (hasrun) {
            if (this.size < 4) {
                return 4 + (this.size + 7) / 8 + 4 * this.size;
            }
            return 4 + (this.size + 7) / 8 + 8 * this.size;
        }
        return 8 + 8 * this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private boolean isRunContainer(int i, boolean hasrun) {
        if (hasrun) {
            int mask;
            byte j = this.buffer.get(4 + i / 8);
            return (j & (mask = 1 << i % 8)) != 0;
        }
        return false;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.limit());
        } else {
            ByteBuffer tmp = this.buffer.duplicate();
            tmp.position(0);
            try (WritableByteChannel channel = Channels.newChannel((OutputStream)((Object)out));){
                channel.write(tmp);
            }
        }
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put(this.buffer.duplicate());
    }

    @Override
    public int serializedSizeInBytes() {
        return this.buffer.limit();
    }

    @Override
    public int size() {
        return this.size;
    }

    private int unsignedBinarySearch(char k) {
        return this.branchyUnsignedBinarySearch(k);
    }

    @Override
    public int first() {
        this.assertNonEmpty();
        char firstKey = this.getKeyAtIndex(0);
        MappeableContainer container2 = this.getContainerAtIndex(0);
        return firstKey << 16 | container2.first();
    }

    @Override
    public int last() {
        this.assertNonEmpty();
        char lastKey = this.getKeyAtIndex(this.size - 1);
        MappeableContainer container2 = this.getContainerAtIndex(this.size - 1);
        return lastKey << 16 | container2.last();
    }

    private void assertNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException("Empty ImmutableRoaringArray");
        }
    }
}

