/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.RegexEngine;

public class RegexJava
implements RegexEngine {
    private Pattern regexPattern;

    public RegexJava(String pattern, String flags) {
        this.regexPattern = RegexJava.makePattern("Regex", pattern, flags);
    }

    @Override
    public boolean match(String s) {
        Matcher m = this.regexPattern.matcher(s);
        return m.find();
    }

    public static Pattern makePattern(String label, String patternStr, String flags) {
        try {
            int mask = 0;
            if (flags != null) {
                mask = RegexJava.makeMask(flags);
                if (flags.contains("q")) {
                    patternStr = Pattern.quote(patternStr);
                }
            }
            return Pattern.compile(patternStr, mask);
        }
        catch (PatternSyntaxException pEx) {
            throw new ExprEvalException(label + " pattern exception: " + pEx);
        }
    }

    public static int makeMask(String modifiers) {
        if (modifiers == null) {
            return 0;
        }
        int newMask = 0;
        block6: for (int i = 0; i < modifiers.length(); ++i) {
            switch (modifiers.charAt(i)) {
                case 'i': {
                    newMask |= 0x40;
                    newMask |= 2;
                    continue block6;
                }
                case 'm': {
                    newMask |= 8;
                    continue block6;
                }
                case 's': {
                    newMask |= 0x20;
                    continue block6;
                }
                case 'q': {
                    continue block6;
                }
                default: {
                    throw new ExprEvalException("Unsupported flag in regex modifiers: " + modifiers.charAt(i));
                }
            }
        }
        return newMask;
    }
}

