/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput1;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIProviderAny;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.rdfxml.xmlinput1.ALiteral;
import org.apache.jena.rdfxml.xmlinput1.ARPErrorNumbers;
import org.apache.jena.rdfxml.xmlinput1.ARPOptions;
import org.apache.jena.rdfxml.xmlinput1.AResource;
import org.apache.jena.rdfxml.xmlinput1.JenaHandler;
import org.apache.jena.rdfxml.xmlinput1.ParseException;
import org.apache.jena.rdfxml.xmlinput1.impl.RDFXMLParser;
import org.apache.jena.shared.DoesNotExistException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.UnknownPropertyException;
import org.apache.jena.shared.WrappedIOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class RDFXMLReader
implements RDFReaderI,
ARPErrorNumbers {
    private static final String saxFeaturesURL = "http://xml.org/sax/features/";
    private static final String saxPropertiesURL = "http://xml.org/sax/properties/";
    private static final String apacheFeaturesURL = "http://apache.org/xml/features/";
    private static final String apachePropertiesURL = "http://apache.org/xml/properties/";
    static final String arpPropertiesURL = "http://jena.hpl.hp.com/arp/properties/";
    static final int arpPropertiesURLLength = "http://jena.hpl.hp.com/arp/properties/".length();
    private final boolean resolveInitialXmlBase;
    private final RDFXMLParser arpf;
    private Model model;
    private JenaHandler handler;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public RDFXMLReader() {
        this.arpf = RDFXMLParser.create();
        this.resolveInitialXmlBase = true;
    }

    public RDFXMLReader(boolean resolveInitialXmlBase) {
        this.arpf = RDFXMLParser.create();
        this.resolveInitialXmlBase = resolveInitialXmlBase;
    }

    @Override
    public void read(Model m, String url) throws JenaException {
        try {
            String encoding;
            int count = 0;
            String connectionURL = url;
            URLConnection conn = null;
            while (conn == null) {
                URLConnection conn2 = new URL(connectionURL).openConnection();
                if (!(conn2 instanceof HttpURLConnection)) {
                    conn = conn2;
                    break;
                }
                if (++count > 10) {
                    throw new JenaException("Too many redirects followed for " + url);
                }
                HttpURLConnection httpURLConnection = (HttpURLConnection)conn2;
                conn2.setRequestProperty("accept", "application/rdf+xml, application/xml; q=0.8, text/xml; q=0.7, application/rss+xml; q=0.3, */*; q=0.2");
                int statusCode = httpURLConnection.getResponseCode();
                if (statusCode < 300 || statusCode >= 400) {
                    conn = conn2;
                    break;
                }
                connectionURL = conn2.getHeaderField("Location");
                if (connectionURL != null && !url.equals(connectionURL)) continue;
                throw new JenaException("Failed to follow redirects for " + url);
            }
            if ((encoding = conn.getContentEncoding()) == null) {
                this.read(m, conn.getInputStream(), url);
            } else {
                this.read(m, (Reader)new InputStreamReader(conn.getInputStream(), encoding), url);
            }
        }
        catch (FileNotFoundException e2) {
            throw new DoesNotExistException(url);
        }
        catch (IOException e3) {
            throw new JenaException(e3);
        }
    }

    private static Node convert(ALiteral lit) {
        String dtURI = lit.getDatatypeURI();
        if (dtURI == null) {
            return NodeFactory.createLiteralLang(lit.toString(), lit.getLang());
        }
        if (lit.isWellFormedXML()) {
            return NodeFactory.createLiteral(lit.toString(), null, XMLLiteralType.theXMLLiteralType);
        }
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
        return NodeFactory.createLiteralDT(lit.toString(), dt);
    }

    private static Node convert(AResource r) {
        if (!r.isAnonymous()) {
            return NodeFactory.createURI(r.getURI());
        }
        Node rr = (Node)r.getUserData();
        if (rr == null) {
            rr = NodeFactory.createBlankNode();
            r.setUserData(rr);
        }
        return rr;
    }

    static Triple convert(AResource s, AResource p, AResource o) {
        return Triple.create(RDFXMLReader.convert(s), RDFXMLReader.convert(p), RDFXMLReader.convert(o));
    }

    static Triple convert(AResource s, AResource p, ALiteral o) {
        return Triple.create(RDFXMLReader.convert(s), RDFXMLReader.convert(p), RDFXMLReader.convert(o));
    }

    private void read(Model m, InputSource inputS, String xmlBase) throws JenaException {
        this.model = m;
        this.read(this.model.getGraph(), inputS, xmlBase, this.model);
    }

    private synchronized void read(Graph g, InputSource inputS, String xmlBase, Model m) {
        try {
            if (xmlBase != null && this.resolveInitialXmlBase) {
                xmlBase = IRIs.resolve(xmlBase);
            }
        }
        catch (IRIException ex) {
            ParseException parseException = new ParseException(2, null, -1, -1, ex.getMessage());
            this.errorHandler.error(parseException);
            throw new JenaException(parseException);
        }
        try {
            g.getEventManager().notifyEvent(g, GraphEvents.startRead);
            inputS.setSystemId(xmlBase);
            this.handler = new JenaHandler(g, m, this.errorHandler);
            this.handler.useWith(this.arpf.getHandlers());
            this.arpf.parse(inputS, xmlBase);
        }
        catch (IOException e2) {
            throw new WrappedIOException(e2);
        }
        catch (SAXException e3) {
            throw new JenaException(e3);
        }
        finally {
            g.getEventManager().notifyEvent(g, GraphEvents.finishRead);
            this.handler = null;
        }
    }

    @Override
    public void read(Model m, Reader reader, String xmlBase) throws JenaException {
        this.read(m, new InputSource(reader), xmlBase);
    }

    public void read(Graph g, Reader reader, String xmlBase) throws JenaException {
        this.read(g, new InputSource(reader), xmlBase, null);
    }

    @Override
    public void read(Model m, InputStream in, String xmlBase) throws JenaException {
        this.read(m, new InputSource(in), xmlBase);
    }

    public void read(Graph g, InputStream in, String xmlBase) {
        this.read(g, new InputSource(in), xmlBase, null);
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        JenaHandler h = this.handler;
        if (h != null) {
            h.setErrorHandler(errHandler);
        }
        return old;
    }

    @Override
    public Object setProperty(String str2, Object value) throws JenaException {
        Object obj = value;
        if (str2.startsWith("http:")) {
            if (str2.startsWith(arpPropertiesURL)) {
                return this.setArpProperty(str2.substring(arpPropertiesURLLength), obj);
            }
            if (str2.startsWith(saxPropertiesURL) || str2.startsWith(apachePropertiesURL)) {
                Object old;
                try {
                    old = this.arpf.getSAXParser().getProperty(str2);
                }
                catch (SAXNotSupportedException ns) {
                    old = null;
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str2));
                    return null;
                }
                try {
                    this.arpf.getSAXParser().setProperty(str2, obj);
                }
                catch (SAXNotSupportedException ns) {
                    this.errorHandler.error(new JenaException(ns));
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str2));
                    return null;
                }
                return old;
            }
            if (str2.startsWith(saxFeaturesURL) || str2.startsWith(apacheFeaturesURL)) {
                Boolean old;
                try {
                    old = this.arpf.getSAXParser().getFeature(str2);
                }
                catch (SAXNotSupportedException ns) {
                    old = null;
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str2));
                    return null;
                }
                try {
                    this.arpf.getSAXParser().setFeature(str2, (Boolean)obj);
                }
                catch (SAXNotSupportedException ns) {
                    this.errorHandler.error(new JenaException(ns));
                }
                catch (SAXNotRecognizedException nr) {
                    this.errorHandler.error(new UnknownPropertyException(str2));
                    return null;
                }
                catch (ClassCastException cc) {
                    this.errorHandler.error(new JenaException(new SAXNotSupportedException("Feature: '" + str2 + "' can only have a boolean value.")));
                }
                return old;
            }
        }
        return this.setArpProperty(str2, obj);
    }

    private Object setArpProperty(String str2, Object v) {
        return RDFXMLReader.processArpOptions(this.getOptions(), str2, v, this.errorHandler);
    }

    public ARPOptions getOptions() {
        return this.arpf.getOptions();
    }

    public void setOptionsWith(ARPOptions opts) {
        this.arpf.setOptionsWith(opts);
    }

    static Object processArpOptions(ARPOptions options, String str2, Object v, RDFErrorHandler eh) {
        int cond;
        str2 = str2.toUpperCase();
        if (v == null) {
            v = "";
        }
        if (v instanceof String) {
            v = ((String)v).toUpperCase(Locale.ENGLISH);
        }
        if (str2.equals("ERROR-MODE")) {
            if (v instanceof String) {
                String val = (String)v;
                options.setIRIProvider(SystemIRIx.getProvider());
                if (val.equals("LAX")) {
                    options.setLaxErrorMode();
                    options.setIRIProvider(new IRIProviderAny());
                    return null;
                }
                if (val.equals("DEFAULT")) {
                    options.setDefaultErrorMode();
                    return null;
                }
                if (val.equals("STRICT")) {
                    options.setStrictErrorMode();
                    return null;
                }
                if (val.equals("STRICT-WARNING")) {
                    options.setStrictErrorMode(1);
                    return null;
                }
                if (val.equals("STRICT-FATAL")) {
                    options.setStrictErrorMode(3);
                    return null;
                }
                if (val.equals("STRICT-IGNORE")) {
                    options.setStrictErrorMode(0);
                    return null;
                }
                if (val.equals("STRICT-ERROR")) {
                    options.setStrictErrorMode(2);
                    return null;
                }
            }
            eh.error(new IllegalArgumentException("Property \"ERROR-MODE\" takes the following values: \"default\", \"lax\", \"strict\", \"strict-ignore\", \"strict-warning\", \"strict-error\", \"strict.error\"."));
            return null;
        }
        if (str2.equals("EMBEDDING")) {
            if (v instanceof String) {
                v = Boolean.valueOf((String)v);
            }
            if (v instanceof Boolean) {
                return options.setEmbedding((Boolean)v);
            }
            eh.error(new IllegalArgumentException("Property \"EMBEDDING\" requires a boolean value."));
            boolean old = options.setEmbedding(false);
            options.setEmbedding(old);
            return old;
        }
        if ((str2.startsWith("ERR_") || str2.startsWith("IGN_") || str2.startsWith("WARN_")) && (cond = ParseException.errorCode(str2)) != -1) {
            if (v instanceof String) {
                if (((String)v).startsWith("EM_") && (val = ParseException.errorCode((String)v)) != -1) {
                    int rslt = options.setErrorMode(cond, val);
                    return rslt;
                }
            } else if (v instanceof Integer) {
                val = (Integer)v;
                switch (val) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        int rslt = options.setErrorMode(cond, val);
                        return rslt;
                    }
                }
            }
            eh.error(new IllegalArgumentException("Property \"" + str2 + "\" cannot have value: " + v.toString()));
            int old = options.setErrorMode(cond, 2);
            options.setErrorMode(cond, old);
            return old;
        }
        if (str2.equals("IRI-RULES")) {
            IRIProvider old = options.getIRIProvider();
            if (v.equals("STRICT")) {
                options.setIRIProvider(SystemIRIx.getProvider());
            } else if (v.equals("IRI")) {
                options.setIRIProvider(SystemIRIx.getProvider());
            } else if (v.equals("LAX")) {
                options.setIRIProvider(new IRIProviderAny());
            } else {
                eh.error(new IllegalArgumentException("Property \"IRI-RULES\" requires one of 'STRICT', 'IRI' or 'LAX'"));
            }
            return old;
        }
        eh.error(new UnknownPropertyException(str2));
        return null;
    }
}

