/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import java.net.http.HttpClient;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryType;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.Syntax;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdfconnection.JenaConnectionException;
import org.apache.jena.rdflink.LibRDFLink;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkHTTPBuilder;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecApp;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.http.DSP;
import org.apache.jena.sparql.exec.http.GSP;
import org.apache.jena.sparql.exec.http.QueryExecHTTP;
import org.apache.jena.sparql.exec.http.QueryExecHTTPBuilder;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.exec.http.UpdateExecHTTP;
import org.apache.jena.sparql.exec.http.UpdateExecHTTPBuilder;
import org.apache.jena.sparql.exec.http.UpdateSendMode;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.Txn;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class RDFLinkHTTP
implements RDFLink {
    private boolean isOpen = true;
    protected final String destination;
    protected final String svcQuery;
    protected final String svcUpdate;
    protected final String svcGraphStore;
    protected final Transactional txnLifecycle;
    protected final HttpClient httpClient;
    protected final RDFFormat outputQuads;
    protected final RDFFormat outputTriples;
    protected final String acceptGraph;
    protected final String acceptDataset;
    protected final String acceptSelectResult;
    protected final String acceptAskResult;
    protected final String acceptSparqlResults;
    protected final boolean parseCheckQueries;
    protected final boolean parseCheckUpdates;
    protected final QuerySendMode querySendMode;
    protected final UpdateSendMode updateSendMode;

    public static RDFLinkHTTPBuilder newBuilder() {
        return new RDFLinkHTTPBuilder();
    }

    public static RDFLinkHTTPBuilder service(String destinationURL) {
        return new RDFLinkHTTPBuilder().destination(destinationURL);
    }

    public static RDFLinkHTTPBuilder from(RDFLinkHTTP base) {
        return new RDFLinkHTTPBuilder(base);
    }

    protected RDFLinkHTTP(Transactional txnLifecycle, HttpClient httpClient, String destination, String queryURL, String updateURL, String gspURL, RDFFormat outputQuads, RDFFormat outputTriples, String acceptDataset, String acceptGraph, String acceptSparqlResults, String acceptSelectResult, String acceptAskResult, boolean parseCheckQueries, boolean parseCheckUpdates, QuerySendMode querySendMode, UpdateSendMode updateSendMode) {
        HttpClient hc;
        HttpClient httpClient2 = hc = httpClient != null ? httpClient : HttpEnv.getDftHttpClient();
        if (txnLifecycle == null) {
            txnLifecycle = TransactionalLock.createMRPlusSW();
        }
        this.httpClient = hc;
        this.destination = destination;
        this.svcQuery = queryURL;
        this.svcUpdate = updateURL;
        this.svcGraphStore = gspURL;
        this.txnLifecycle = txnLifecycle;
        this.outputQuads = outputQuads;
        this.outputTriples = outputTriples;
        this.acceptDataset = acceptDataset;
        this.acceptGraph = acceptGraph;
        this.acceptSparqlResults = acceptSparqlResults;
        this.acceptSelectResult = acceptSelectResult;
        this.acceptAskResult = acceptAskResult;
        this.parseCheckQueries = parseCheckQueries;
        this.parseCheckUpdates = parseCheckUpdates;
        this.querySendMode = querySendMode;
        this.updateSendMode = updateSendMode;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getQueryEndpoint() {
        return this.svcQuery;
    }

    public String getUpdateEndpoint() {
        return this.svcUpdate;
    }

    public String getGraphStoreEndpoint() {
        return this.svcGraphStore;
    }

    @Override
    public void queryRowSet(String queryString, Consumer<RowSet> rowSetAction) {
        Txn.executeRead(this, () -> {
            try (QueryExec qExec = this.query(queryString, QueryType.SELECT);){
                RowSet rs = qExec.select();
                rowSetAction.accept(rs);
            }
        });
    }

    @Override
    public void querySelect(String queryString, Consumer<Binding> rowAction) {
        Txn.executeRead(this, () -> {
            try (QueryExec qExec = this.query(queryString, QueryType.SELECT);){
                qExec.select().forEachRemaining(rowAction);
            }
        });
    }

    @Override
    public Graph queryConstruct(String queryString) {
        return Txn.calculateRead(this, () -> {
            try (QueryExec qExec = this.query(queryString, QueryType.CONSTRUCT);){
                Graph graph = qExec.construct();
                return graph;
            }
        });
    }

    @Override
    public Graph queryDescribe(String queryString) {
        return Txn.calculateRead(this, () -> {
            try (QueryExec qExec = this.query(queryString, QueryType.DESCRIBE);){
                Graph graph = qExec.describe();
                return graph;
            }
        });
    }

    @Override
    public boolean queryAsk(String queryString) {
        return Txn.calculateRead(this, () -> {
            try (QueryExec qExec = this.query(queryString, QueryType.ASK);){
                Boolean bl = qExec.ask();
                return bl;
            }
        });
    }

    protected QueryExec query(String queryString, QueryType queryType) {
        Objects.requireNonNull(queryString);
        return this.queryExec(null, queryString, queryType);
    }

    @Override
    public QueryExec query(String queryString) {
        Objects.requireNonNull(queryString);
        return this.queryExec(null, queryString, null);
    }

    @Override
    public QueryExec query(Query query) {
        Objects.requireNonNull(query);
        return this.queryExec(query, null, null);
    }

    @Override
    public QueryExecBuilder newQuery() {
        return this.createQExecBuilder();
    }

    private QueryExec queryExec(Query query, String queryString, QueryType queryType) {
        QueryExecHTTPBuilderOverRDFLinkHTTP builder = this.createQExecBuilder();
        if (queryString != null) {
            builder.queryStringValidated(queryString, Syntax.defaultQuerySyntax, queryType);
        }
        if (query != null) {
            builder.query(query);
        }
        return QueryExecApp.create(builder, null, query, queryString);
    }

    private QueryExecHTTPBuilderOverRDFLinkHTTP createQExecBuilder() {
        this.checkQuery();
        QueryExecHTTPBuilderOverRDFLinkHTTP builder = new QueryExecHTTPBuilderOverRDFLinkHTTP();
        ((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)builder.endpoint(this.svcQuery)).httpClient(this.httpClient)).sendMode(this.querySendMode);
        return builder;
    }

    private void acc(StringBuilder sBuff, String acceptString) {
        if (acceptString == null) {
            return;
        }
        if (sBuff.length() != 0) {
            sBuff.append(", ");
        }
        sBuff.append(acceptString);
    }

    @Override
    public UpdateExecBuilder newUpdate() {
        return this.createUExecBuilder();
    }

    private UpdateExecHTTPBuilder createUExecBuilder() {
        return (UpdateExecHTTPBuilder)((UpdateExecHTTPBuilder)((UpdateExecHTTPBuilder)UpdateExecHTTPBuilder.create().endpoint(this.svcUpdate)).httpClient(this.httpClient)).sendMode(this.updateSendMode);
    }

    @Override
    public void update(String updateString) {
        Objects.requireNonNull(updateString);
        this.updateExec(null, updateString);
    }

    @Override
    public void update(UpdateRequest update) {
        Objects.requireNonNull(update);
        this.updateExec(update, null);
    }

    private void updateExec(UpdateRequest update, String updateString) {
        this.checkUpdate();
        if (update == null && updateString == null) {
            throw new InternalErrorException("Both update request and update string are null");
        }
        UpdateRequest actual = null;
        if (update == null && this.parseCheckUpdates) {
            actual = UpdateFactory.create(updateString);
        }
        String updateStringToSend = updateString != null ? updateString : update.toString();
        ((UpdateExecHTTP)((UpdateExecHTTPBuilder)this.createUExecBuilder().updateString(updateStringToSend)).build()).execute();
    }

    @Override
    public Graph get(Node graphName) {
        this.checkGSP();
        return ((GSP)this.gsp(graphName).acceptHeader(this.acceptGraph)).GET();
    }

    @Override
    public Graph get() {
        this.checkGSP();
        return ((GSP)this.gsp().acceptHeader(this.acceptGraph)).GET();
    }

    @Override
    public void load(String file) {
        this.checkGSP();
        this.gsp().POST(file);
    }

    @Override
    public void load(Node graphName, String file) {
        this.checkGSP();
        this.gsp(graphName).POST(file);
    }

    @Override
    public void load(Graph graph) {
        ((GSP)this.gsp().contentType(this.outputTriples)).POST(graph);
    }

    @Override
    public void load(Node graphName, Graph graph) {
        ((GSP)this.gsp(graphName).contentType(this.outputTriples)).POST(graph);
    }

    @Override
    public void put(String file) {
        this.checkGSP();
        this.gsp().PUT(file);
    }

    @Override
    public void put(Node graphName, String file) {
        this.checkGSP();
        this.gsp(graphName).PUT(file);
    }

    @Override
    public void put(Graph graph) {
        this.checkGSP();
        ((GSP)this.gsp().contentType(this.outputTriples)).PUT(graph);
    }

    @Override
    public void put(Node graphName, Graph graph) {
        this.checkGSP();
        ((GSP)this.gsp(graphName).contentType(this.outputTriples)).PUT(graph);
    }

    private String ct(RDFFormat format) {
        return format.getLang().getHeaderString();
    }

    private GSP gsp() {
        return ((GSP)this.gspRequest().acceptHeader(this.acceptGraph)).defaultGraph();
    }

    private GSP gsp(Node graphName) {
        if (LibRDFLink.isDefault(graphName)) {
            return ((GSP)this.gspRequest().acceptHeader(this.acceptGraph)).defaultGraph();
        }
        return ((GSP)this.gspRequest().acceptHeader(this.acceptGraph)).graphName(graphName);
    }

    private GSP gspRequest() {
        GSP gsp = GSP.service(this.svcGraphStore);
        if (this.httpClient != null) {
            gsp.httpClient(this.httpClient);
        }
        return gsp;
    }

    private DSP dspRequest() {
        DSP dsp = DSP.service(this.svcGraphStore);
        if (this.httpClient != null) {
            dsp.httpClient(this.httpClient);
        }
        return dsp;
    }

    @Override
    public void delete(Node graphName) {
        this.checkGSP();
        this.gsp(graphName).DELETE();
    }

    @Override
    public void delete() {
        this.checkGSP();
        this.gsp().DELETE();
    }

    @Override
    public DatasetGraph getDataset() {
        this.checkDataset();
        return ((DSP)this.dspRequest().acceptHeader(this.acceptDataset)).GET();
    }

    @Override
    public void loadDataset(String file) {
        this.checkDataset();
        ((DSP)this.dspRequest().contentType(this.outputQuads)).POST(file);
    }

    @Override
    public void loadDataset(DatasetGraph dataset) {
        this.checkDataset();
        ((DSP)this.dspRequest().contentType(this.outputQuads)).POST(dataset);
    }

    @Override
    public void putDataset(String file) {
        this.checkDataset();
        ((DSP)this.dspRequest().contentType(this.outputQuads)).PUT(file);
    }

    @Override
    public void putDataset(DatasetGraph dataset) {
        this.checkDataset();
        ((DSP)this.dspRequest().contentType(this.outputQuads)).PUT(dataset);
    }

    @Override
    public void clearDataset() {
        this.checkOpen();
        this.update("CLEAR ALL");
    }

    protected void checkQuery() {
        this.checkOpen();
        if (this.svcQuery == null) {
            throw new ARQException("No query service defined for this RDFLink");
        }
    }

    protected void checkUpdate() {
        this.checkOpen();
        if (this.svcUpdate == null) {
            throw new ARQException("No update service defined for this RDFLink");
        }
    }

    protected void checkGSP() {
        this.checkOpen();
        if (this.svcGraphStore == null) {
            throw new ARQException("No SPARQL Graph Store service defined for this RDFLink");
        }
    }

    protected void checkDataset() {
        this.checkOpen();
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URL provided");
        }
    }

    protected void checkOpen() {
        if (!this.isOpen) {
            throw new ARQException("closed");
        }
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void begin() {
        this.txnLifecycle.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.txnLifecycle.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txnLifecycle.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote promote) {
        return this.txnLifecycle.promote(promote);
    }

    @Override
    public void commit() {
        this.txnLifecycle.commit();
    }

    @Override
    public void abort() {
        this.txnLifecycle.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txnLifecycle.isInTransaction();
    }

    @Override
    public void end() {
        this.txnLifecycle.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txnLifecycle.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.txnLifecycle.transactionType();
    }

    class QueryExecHTTPBuilderOverRDFLinkHTTP
    extends QueryExecHTTPBuilder {
        protected QueryType queryType = QueryType.UNKNOWN;
        protected Query parsedQuery = null;

        protected QueryExecHTTPBuilderOverRDFLinkHTTP() {
        }

        protected QueryExecHTTPBuilder queryString(String queryString, QueryType queryType, Query parsedQuery) {
            super.queryString(queryString);
            this.queryType = queryType != null ? queryType : QueryType.UNKNOWN;
            this.parsedQuery = parsedQuery;
            return this.thisBuilder();
        }

        @Override
        public QueryExecHTTPBuilder queryString(String queryString) {
            return this.queryString(queryString, null, null);
        }

        protected QueryExecHTTPBuilder queryStringValidated(String queryString, Syntax syntax, QueryType fallbackQueryType) {
            Query parsedQuery = RDFLinkHTTP.this.parseCheckQueries ? QueryFactory.create(queryString, syntax) : null;
            QueryType finalQueryType = parsedQuery != null ? parsedQuery.queryType() : fallbackQueryType;
            return this.queryString(queryString, finalQueryType, parsedQuery);
        }

        @Override
        protected void setQuery(Query query, String queryStr) {
            super.setQuery(query, queryStr);
            this.parsedQuery = query;
            this.queryType = query == null ? QueryType.UNKNOWN : query.queryType();
        }

        @Override
        protected QueryExecHTTP buildX(HttpClient hClient, Query queryActual, String queryStringActual, Context cxt) {
            if (this.appAcceptHeader == null) {
                String requestAcceptHeader = null;
                switch (this.queryType) {
                    case SELECT: {
                        if (RDFLinkHTTP.this.acceptSelectResult == null) break;
                        requestAcceptHeader = RDFLinkHTTP.this.acceptSelectResult;
                        break;
                    }
                    case ASK: {
                        if (RDFLinkHTTP.this.acceptAskResult == null) break;
                        requestAcceptHeader = RDFLinkHTTP.this.acceptAskResult;
                        break;
                    }
                    case DESCRIBE: 
                    case CONSTRUCT: {
                        if (this.parsedQuery != null && this.parsedQuery.isConstructQuad()) {
                            if (RDFLinkHTTP.this.acceptDataset == null) break;
                            requestAcceptHeader = RDFLinkHTTP.this.acceptDataset;
                            break;
                        }
                        if (RDFLinkHTTP.this.acceptGraph == null) break;
                        requestAcceptHeader = RDFLinkHTTP.this.acceptGraph;
                        break;
                    }
                    case UNKNOWN: {
                        if (RDFLinkHTTP.this.acceptSparqlResults != null) {
                            requestAcceptHeader = RDFLinkHTTP.this.acceptSparqlResults;
                            break;
                        }
                        requestAcceptHeader = "*/*";
                        break;
                    }
                }
                if (requestAcceptHeader == null) {
                    throw new JenaConnectionException("No Accept header");
                }
                this.acceptHeader(requestAcceptHeader);
            }
            return super.buildX(hClient, queryActual, queryStringActual, cxt);
        }
    }
}

