/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.IteratorCloseable;

public abstract class IteratorBase<X>
implements IteratorCloseable<X> {
    private boolean hasClosed = false;

    protected IteratorBase() {
    }

    protected abstract boolean hasNextElt();

    protected abstract X nextElt();

    protected abstract void onFinish();

    @Override
    public final boolean hasNext() {
        boolean b = this.hasNextElt();
        if (!b) {
            this.close();
        }
        return b;
    }

    @Override
    public final X next() {
        try {
            return this.nextElt();
        }
        catch (NoSuchElementException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void close() {
        if (!this.hasClosed) {
            this.onFinish();
        }
        this.hasClosed = true;
    }
}

