/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.document;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.json.JsonProvider;
import com.apicatalog.jsonld.json.JsonUtils;
import jakarta.json.JsonException;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Optional;

public final class JsonDocument
implements Document {
    private static final String PLUS_JSON = "+json";
    private final MediaType contentType;
    private final JsonStructure structure;
    private final String profile;
    private URI documentUrl;
    private URI contentUrl;

    private JsonDocument(MediaType type, String profile, JsonStructure structure) {
        this.contentType = type;
        this.profile = profile;
        this.structure = structure;
    }

    public static JsonDocument of(JsonStructure structure) {
        return JsonDocument.of(MediaType.JSON, structure);
    }

    public static JsonDocument of(MediaType contentType, JsonStructure structure) {
        if (contentType == null) {
            throw new IllegalArgumentException("The provided JSON type is null.");
        }
        JsonDocument.assertContentType(contentType);
        if (structure == null) {
            throw new IllegalArgumentException("The provided JSON structure is null.");
        }
        return new JsonDocument(MediaType.of(contentType.type(), contentType.subtype()), contentType.parameters().firstValue("profile").orElse(null), structure);
    }

    public static final JsonDocument of(InputStream is) throws JsonLdError {
        return JsonDocument.of(MediaType.JSON, is);
    }

    public static final JsonDocument of(MediaType contentType, InputStream is) throws JsonLdError {
        JsonDocument.assertContentType(contentType);
        if (is == null) {
            throw new IllegalArgumentException("The input stream parameter cannot be null.");
        }
        JsonParser parser = JsonProvider.instance().createParser(is);
        try {
            JsonDocument jsonDocument = JsonDocument.doParse(contentType, parser);
            if (parser != null) {
                parser.close();
            }
            return jsonDocument;
        }
        catch (Throwable throwable) {
            try {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonException e2) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e2);
            }
        }
    }

    public static final JsonDocument of(Reader reader) throws JsonLdError {
        return JsonDocument.of(MediaType.JSON, reader);
    }

    public static final JsonDocument of(MediaType contentType, Reader reader) throws JsonLdError {
        JsonDocument.assertContentType(contentType);
        if (reader == null) {
            throw new IllegalArgumentException("The reader parameter cannot be null.");
        }
        JsonParser parser = JsonProvider.instance().createParser(reader);
        try {
            JsonDocument jsonDocument = JsonDocument.doParse(contentType, parser);
            if (parser != null) {
                parser.close();
            }
            return jsonDocument;
        }
        catch (Throwable throwable) {
            try {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JsonException e2) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e2);
            }
        }
    }

    private static final JsonDocument doParse(MediaType contentType, JsonParser parser) throws JsonLdError {
        if (!parser.hasNext()) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Nothing to read. Provided document is empty.");
        }
        parser.next();
        JsonValue root2 = parser.getValue();
        String profile = contentType.parameters().firstValue("profile").orElse(null);
        if (JsonUtils.isArray(root2)) {
            return new JsonDocument(contentType, profile, root2.asJsonArray());
        }
        if (JsonUtils.isObject(root2)) {
            return new JsonDocument(MediaType.of(contentType.type(), contentType.subtype()), profile, root2.asJsonObject());
        }
        throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "JSON document's top level element must be JSON array or object.");
    }

    public static final boolean accepts(MediaType contentType) {
        return contentType != null && (MediaType.JSON_LD.match(contentType) || MediaType.JSON.match(contentType) || contentType.subtype().toLowerCase().endsWith(PLUS_JSON));
    }

    private static final void assertContentType(MediaType contentType) {
        if (!JsonDocument.accepts(contentType)) {
            throw new IllegalArgumentException("Unsupported media type '" + contentType + "'. Supported content types are [" + MediaType.JSON_LD + ", " + MediaType.JSON + ", +json]");
        }
    }

    @Override
    public Optional<JsonStructure> getJsonContent() {
        return Optional.of(this.structure);
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public URI getContextUrl() {
        return this.contentUrl;
    }

    @Override
    public void setContextUrl(URI contextUrl) {
        this.contentUrl = contextUrl;
    }

    @Override
    public URI getDocumentUrl() {
        return this.documentUrl;
    }

    @Override
    public void setDocumentUrl(URI documentUrl) {
        this.documentUrl = documentUrl;
    }

    @Override
    public Optional<String> getProfile() {
        return Optional.ofNullable(this.profile);
    }
}

