/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables.maps;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.dap.variables.maps.MapEntryReference;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class MapSliceReference
extends IdentifiableReference<Map<Object, Object>> {
    private final String name;
    private final int from;
    private final int to;

    public MapSliceReference(IEolContext context, String name, Map<Object, Object> target, int from, int to) {
        super(context, target);
        this.from = from;
        this.to = to;
        this.name = name;
    }

    @Override
    public String getName() {
        return String.format("%s[%d..%d]", this.name, this.from, this.to - 1);
    }

    @Override
    public String getValue() {
        return String.format("<slice with %d elements>", this.to - this.from);
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> vars = new ArrayList<IVariableReference>(this.to - this.from);
        Iterator itEntries = ((Map)this.target).keySet().iterator();
        int i = 0;
        while (i < this.from && itEntries.hasNext()) {
            itEntries.next();
            ++i;
        }
        while (i < this.to && itEntries.hasNext()) {
            Object key = itEntries.next();
            vars.add(state.putOrGetReference(new MapEntryReference(this.context, String.format("%s[%d]", this.name, i), (Map)this.target, key)));
            ++i;
        }
        return vars;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.from, this.name, this.to);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapSliceReference other = (MapSliceReference)obj;
        return this.from == other.from && Objects.equals(this.name, other.name) && this.to == other.to;
    }
}

