/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates.notify;

import java.util.List;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.ecore.delegates.DelegateContext;
import org.eclipse.epsilon.ecore.delegates.DelegateUri;
import org.eclipse.epsilon.ecore.delegates.notify.DelegateEPackageAdapter;
import org.eclipse.epsilon.ecore.delegates.notify.DelegateResourceAdapter;
import org.eclipse.epsilon.ecore.delegates.notify.DelegateResourceSetAdapter;

public abstract class Adapters {
    protected final DelegateUri delegateURI;
    private final DelegateContext.ContextFactory defaultCtxFctry;
    private final DelegateResourceAdapter dlgtRsrcAdptr;
    private final DelegateContext.ContextFactory.Registry defaultCtxFctryRegistry;

    public Adapters(DelegateUri delegateUri, DelegateContext.ContextFactory defaultCtxFctry, DelegateContext.ContextFactory.Registry defaultCtxFctryRegistry) {
        this.delegateURI = delegateUri;
        this.defaultCtxFctry = defaultCtxFctry;
        this.defaultCtxFctryRegistry = defaultCtxFctryRegistry;
        this.dlgtRsrcAdptr = new DelegateResourceAdapter(this);
    }

    public abstract DelegateResourceSetAdapter getAdapter(ResourceSet var1);

    public DelegateEPackageAdapter getAdapter(EPackage ePackage) {
        DelegateEPackageAdapter adapter = this.findAdapter(ePackage);
        if (adapter == null) {
            adapter = new DelegateEPackageAdapter();
            ePackage.eAdapters().add((Object)adapter);
        }
        this.delegateURI.addContext(adapter, () -> this.createContext(ePackage));
        return adapter;
    }

    public DelegateResourceSetAdapter getAdapter(EModelElement modelElement) {
        Resource resource = modelElement.eResource();
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        return this.getAdapter(resourceSet);
    }

    public <T> T getRegistry(EModelElement modelElement, Class<T> registryClass, T defaultRegistry) {
        Resource resource = modelElement.eResource();
        if (resource == null) {
            return defaultRegistry;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return defaultRegistry;
        }
        DelegateResourceSetAdapter adapter = this.getAdapter(resourceSet);
        T registry = null;
        if (adapter != null) {
            registry = adapter.getRegistry(registryClass);
        }
        return registry != null ? registry : (T)defaultRegistry;
    }

    public boolean hasAdapter(EModelElement eObject) {
        return this.delegateURI.isUsedBy(eObject);
    }

    protected DelegateResourceSetAdapter findAdapter(ResourceSet resourceSet) {
        return (DelegateResourceSetAdapter)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), DelegateResourceSetAdapter.class);
    }

    DelegateEPackageAdapter findAdapter(EPackage ePackage) {
        return (DelegateEPackageAdapter)EcoreUtil.getAdapter((List)ePackage.eAdapters(), DelegateEPackageAdapter.class);
    }

    private DelegateContext createContext(EPackage ePackage) {
        DelegateContext.ContextFactory.Registry registry = this.getRegistry((EModelElement)ePackage, DelegateContext.ContextFactory.Registry.class, this.defaultCtxFctryRegistry);
        DelegateContext.ContextFactory factory = this.delegateURI.factory(registry);
        if (factory == null) {
            factory = this.defaultCtxFctry;
        }
        return factory.create(this.delegateURI, ePackage, this.dlgtRsrcAdptr);
    }
}

