/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views;

import java.security.cert.X509Certificate;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.client.exceptions.ESCertificateException;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class CertificateSelectionDialog
extends ElementListSelectionDialog {
    private TableItem selectedTableItem;
    private String alias = "";

    public CertificateSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
        this.setShellStyle(1248);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite grid = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(grid);
        Composite left = new Composite(grid, 0);
        GridLayoutFactory.fillDefaults().applyTo(left);
        Composite right = new Composite(grid, 0);
        GridLayoutFactory.createFrom((GridLayout)layout).margins(layout.marginWidth, 35).applyTo(right);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)right);
        CertificateSelectionDialog.applyDialogFont((Control)right);
        new Label(right, 0).setText("Certificate Alias: ");
        Text certAlias = new Text(right, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)certAlias);
        certAlias.setBackground(Display.getCurrent().getSystemColor(1));
        certAlias.setEditable(false);
        new Label(right, 0).setText("Certificate Details: ");
        Text certDetails = new Text(right, 578);
        GridDataFactory.fillDefaults().grab(true, false).hint(300, 230).applyTo((Control)certDetails);
        certDetails.setBackground(Display.getCurrent().getSystemColor(1));
        certDetails.setEditable(false);
        Composite dialogArea = new Composite(left, 0);
        GridLayoutFactory.fillDefaults().applyTo(dialogArea);
        Control control = super.createDialogArea(dialogArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        Composite certButtonsComposite = new Composite(grid, 0);
        GridLayoutFactory.createFrom((GridLayout)layout).numColumns(3).equalWidth(true).margins(layout.marginWidth, 0).applyTo(certButtonsComposite);
        CertificateSelectionDialog.applyDialogFont((Control)certButtonsComposite);
        Button browse = new Button(certButtonsComposite, 0);
        browse.setText("Import...");
        browse.addSelectionListener((SelectionListener)new CertificateSelectionListener());
        Button delete = new Button(certButtonsComposite, 0);
        delete.setText("Delete");
        delete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (CertificateSelectionDialog.this.selectedTableItem != null && !CertificateSelectionDialog.this.selectedTableItem.getText().equals("")) {
                    String alias = CertificateSelectionDialog.this.selectedTableItem.getText();
                    try {
                        KeyStoreManager.getInstance().deleteCertificate(alias);
                        CertificateSelectionDialog.this.setListElements(KeyStoreManager.getInstance().getCertificates().toArray());
                    }
                    catch (ESCertificateException e1) {
                        CertificateSelectionDialog.this.setErrorMessage(e1.getMessage());
                    }
                }
            }
        });
        this.fFilteredList.addSelectionListener((SelectionListener)new SelectionListenerImplementation(certDetails, certAlias));
        return control;
    }

    public String getCertificateAlias() {
        return this.alias;
    }

    public void setErrorMessage(String errorMessage) {
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Attention", (String)errorMessage);
    }

    class CertificateSelectionListener
    implements SelectionListener {
        CertificateSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell());
            fileDialog.open();
            if (!fileDialog.getFileName().equals("")) {
                String location = String.valueOf(fileDialog.getFilterPath()) + System.getProperty("file.separator") + fileDialog.getFileName();
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), "Select certificate designation", "Please choose a designation for the previously selected certificate: ", "", null);
                inputDialog.setBlockOnOpen(true);
                if (inputDialog.open() != 0) {
                    return;
                }
                String alias = inputDialog.getValue();
                if (alias.equals("")) {
                    alias = "unnamed:" + EcoreUtil.generateUUID();
                }
                try {
                    KeyStoreManager.getInstance().addCertificate(alias, location);
                }
                catch (ESCertificateException e) {
                    CertificateSelectionDialog.this.setErrorMessage(e.getMessage());
                }
                try {
                    CertificateSelectionDialog.this.setListElements(KeyStoreManager.getInstance().getCertificates().toArray());
                }
                catch (ESCertificateException e1) {
                    CertificateSelectionDialog.this.setErrorMessage(e1.getMessage());
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private final class SelectionListenerImplementation
    implements SelectionListener {
        private final Text certDetails;
        private final Text certAlias;

        private SelectionListenerImplementation(Text certDetails, Text certAlias) {
            this.certDetails = certDetails;
            this.certAlias = certAlias;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (((Table)e.getSource()).getItems().length > 0) {
                CertificateSelectionDialog.this.selectedTableItem = ((Table)e.getSource()).getItems()[((Table)e.getSource()).getSelectionIndex()];
                CertificateSelectionDialog.this.alias = CertificateSelectionDialog.this.selectedTableItem.getText();
                try {
                    X509Certificate selectedCertificate = (X509Certificate)KeyStoreManager.getInstance().getCertificate(CertificateSelectionDialog.this.alias);
                    String[] details = selectedCertificate.toString().split("\n");
                    String tmp = "";
                    int i = 2;
                    while (i < 14) {
                        tmp = String.valueOf(tmp) + (i == 7 || i == 8 ? "" : String.valueOf(details[i].trim()) + "\n");
                        ++i;
                    }
                    this.certAlias.setText(CertificateSelectionDialog.this.alias);
                    this.certDetails.setText(tmp);
                }
                catch (ESCertificateException e1) {
                    CertificateSelectionDialog.this.setErrorMessage(e1.getMessage());
                }
            }
        }
    }
}

