/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.CherryPickRevisionCommand;
import org.eclipse.egerrit.internal.core.command.ListBranchesCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.CherryPickInput;
import org.eclipse.egerrit.internal.model.BranchInfo;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.CherryPickDialog;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CherryPickProcess {
    private GerritClient fGerritClient = null;

    public void handleCherryPick(Shell shell, final GerritClient gerritClient, final ChangeInfo changeInfo, final RevisionInfo revision) {
        this.fGerritClient = gerritClient;
        BranchInfo[] listBranchesCmdResult = this.listBranches(changeInfo);
        ArrayList<String> listBranchesRef = new ArrayList<String>();
        Iterator<BranchInfo> it = Arrays.asList(listBranchesCmdResult).iterator();
        while (it.hasNext()) {
            listBranchesRef.add(it.next().getRef());
        }
        final CherryPickDialog cherryPickDialog = new CherryPickDialog((Composite)shell, listBranchesRef, revision.getCommit().getMessage());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean isDone = false;
                while (!isDone) {
                    Object cherryPickCmdResult = "";
                    int ret = cherryPickDialog.open();
                    if (ret == 0) {
                        cherryPickCmdResult = CherryPickProcess.this.cherryPickRevision(changeInfo.getId(), revision.getId(), cherryPickDialog.getBranch(), cherryPickDialog.getMessage());
                        if (cherryPickCmdResult instanceof String) {
                            MessageDialog.open((int)1, null, (String)Messages.CherryPickRevision_9, (String)((String)cherryPickCmdResult), (int)0);
                            continue;
                        }
                        ChangeInfo cherryPickedChangeInfo = (ChangeInfo)cherryPickCmdResult;
                        if (cherryPickedChangeInfo.getId().equals(changeInfo.getId())) {
                            CompletableFuture.runAsync(() -> QueryHelpers.loadBasicInformation(gerritClient, changeInfo, false)).thenRun(() -> changeInfo.setUserSelectedRevision(changeInfo.getRevision()));
                        } else {
                            UIUtils.openAnotherEditor(cherryPickedChangeInfo, CherryPickProcess.this.fGerritClient);
                        }
                        isDone = true;
                        continue;
                    }
                    isDone = true;
                }
            }
        });
    }

    private Object cherryPickRevision(String changeId, String revisionId, String branch, String message) {
        CherryPickRevisionCommand cherryPickCmd = this.fGerritClient.cherryPickRevision(changeId, revisionId);
        CherryPickInput cherryPickInput = new CherryPickInput();
        cherryPickInput.setDestination(branch);
        cherryPickInput.setMessage(message);
        cherryPickCmd.setCommandInput((Object)cherryPickInput);
        ChangeInfo cherryPickResult = null;
        String failureReason = "";
        try {
            cherryPickResult = (ChangeInfo)cherryPickCmd.call();
            if (cherryPickResult == null) {
                return cherryPickCmd.getFailureReason();
            }
            return cherryPickResult;
        }
        catch (EGerritException e3) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
            return failureReason;
        }
    }

    private BranchInfo[] listBranches(ChangeInfo changeInfo) {
        ListBranchesCommand listBranchesCmd = this.fGerritClient.listBranches(changeInfo.getProject());
        BranchInfo[] listBranchesCmdResult = null;
        try {
            listBranchesCmdResult = (BranchInfo[])listBranchesCmd.call();
        }
        catch (EGerritException e3) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
        }
        return listBranchesCmdResult;
    }
}

