/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.OPS;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.PathParam;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;

@ServerEndpoint(value="/srv/{param}")
public class WSCServer {
    private static final System.Logger logger = System.getLogger(WSCServer.class.getName());
    private State state = State.INIT;

    @OnOpen
    public void onOpen(final Session session, final @PathParam(value="param") String op) {
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

            public void onMessage(ByteBuffer message) {
                WSCServer.this.echo(op, IOUtil.byteBufferToString((ByteBuffer)message), session);
            }
        });
    }

    @OnMessage
    public void echo(@PathParam(value="param") String op, String echo, Session session) {
        switch (this.state.ordinal()) {
            case 0: {
                this.state = State.SECOND;
                this.op(op, echo, session);
                break;
            }
            case 1: {
                this.state = State.FINAL;
                this.op(op, echo, session);
                break;
            }
            case 2: {
                try {
                    session.close();
                    break;
                }
                catch (IOException e) {
                    this.onError(session, e);
                }
            }
        }
    }

    private void op(String param, String echo, Session session) {
        if (param == null) {
            throw new RuntimeException("Path param is null");
        }
        OPS op = OPS.valueOf(param);
        switch (op) {
            case TEXT: {
                try {
                    session.getBasicRemote().sendText(echo);
                }
                catch (IOException e) {
                    this.onError(session, e);
                }
                break;
            }
            case TEXTPARTIAL: {
                String[] tokens = echo.split("_");
                for (int i = 0; i != tokens.length; ++i) {
                    try {
                        boolean isLast;
                        boolean bl = isLast = i == tokens.length - 1;
                        if (isLast) {
                            session.getBasicRemote().sendText(tokens[i], true);
                            continue;
                        }
                        session.getBasicRemote().sendText(tokens[i] + "_", false);
                        continue;
                    }
                    catch (IOException e) {
                        this.onError(session, e);
                    }
                }
                break;
            }
            case BINARY: {
                try {
                    session.getBasicRemote().sendBinary(ByteBuffer.wrap(echo.getBytes()));
                }
                catch (IOException e) {
                    this.onError(session, e);
                }
                break;
            }
            case BINARYPARTIAL: {
                String[] tokens = echo.split("_");
                for (int i = 0; i != tokens.length; ++i) {
                    try {
                        ByteBuffer buf;
                        boolean isLast;
                        boolean bl = isLast = i == tokens.length - 1;
                        if (isLast) {
                            buf = ByteBuffer.wrap(tokens[i].getBytes());
                            session.getBasicRemote().sendBinary(buf, true);
                            continue;
                        }
                        buf = ByteBuffer.wrap((tokens[i] + "_").getBytes());
                        session.getBasicRemote().sendBinary(buf, false);
                        continue;
                    }
                    catch (IOException e) {
                        this.onError(session, e);
                    }
                }
                break;
            }
            case PONG: {
                try {
                    session.getBasicRemote().sendPong(ByteBuffer.wrap(echo.getBytes()));
                }
                catch (IOException e) {
                    this.onError(session, e);
                }
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)op) + " not implemented");
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        logger.log(System.Logger.Level.INFO, "@OnError in" + this.getClass().getName());
        t.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)t);
        try {
            if (session.isOpen()) {
                session.getBasicRemote().sendText(message);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static enum State {
        INIT,
        SECOND,
        FINAL;

    }
}

