/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.websocket.spec.application.lifecycle;

import java.util.concurrent.CountDownLatch;

import javax.websocket.EndpointConfig;
import javax.websocket.Session;

public class OuterEndpoint extends InnerEndpoint {
	private InnerEndpoint innerEndpoint;

	public OuterEndpoint(InnerEndpoint innerEndpoint, CountDownLatch latch) {
		super(latch);
		this.innerEndpoint = innerEndpoint;
	}

	@Override
	public void onOpen(Session session, EndpointConfig config) {
		session.addMessageHandler(this);
	}

	@Override
	public void onMessage(String message) {
		this.receivedMessage += message;
		innerEndpoint.sendMessage("anything");
		innerEndpoint.await(5L);
		latch.countDown();
	}
}
