/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AnnotatedTextClient.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import java.io.Reader;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.ee.javax.websocket.session11.common.AlternativeReaderDecoder;

@ClientEndpoint(decoders = { AlternativeReaderDecoder.class })
public class AnnotatedTextClient extends AnnotatedClientEndpoint<String> {

	public AnnotatedTextClient() {
		super(new StringClientEndpoint());
	}

	@OnOpen
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		session.addMessageHandler(Reader.class, new ReaderMessageHandler(
				clientEndpoint));
		super.onOpen(session, config);
	}

	@OnClose
	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	@Override
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}
}
