/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WSTestServerString.java 70269 2013-02-26 13:44:04Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.session;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value = "/TCKTestServerString")
public class WSTestServerString {

    @OnOpen
    public void init(Session session) throws IOException {
        session.getBasicRemote().sendText("========TCKTestServerString opened");
    }

    @OnMessage
    public void respond(String message, Session session) {
        try {
            session.getBasicRemote().sendText("========TCKTestServerString received String: " + message);
            session.getBasicRemote().sendText("========TCKTestServerString responds");
          } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        try {
            session.getBasicRemote().sendText("========TCKTestServerString onError");
        } catch (Exception e) {
            e.printStackTrace();
        }
        t.printStackTrace();
    }
}