/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSSubprotocoledServer.java 71236 2013-03-29 12:29:59Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpoint;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value = "/subprotocoled", subprotocols = { "def", "abc", "ghi" })
public class WSSubprotocoledServer extends WSAbstractServer {

	@OnMessage
	public String operation(String op) {
		return super.op(op);
	}

	@Override
	protected String getConfigurator() {
		String config = super.getConfigurator();
		return config;
	}

	@Override
	protected String getEncoders() {
		String encoders = super.getEncoders();
		return "{" + encoders + "}";
	}

	@Override
	protected String getDecoders() {
		String decoders = super.getDecoders();
		return "{" + decoders + "}";
	}

	@Override
	protected String getSubprotocols() {
		String subprotocols = super.getSubprotocols();
		return "{" + subprotocols + "}";
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		super.onError(session, t);
	}

}
