/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: LibrariedQuestionaire.java 72795 2013-09-04 15:47:07Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.containerprovider.metainf;

import java.security.AccessController;
import java.security.PrivilegedAction;

import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;

public class LibrariedQuestionaire {
	public String getContainerProviderName() {
		WebSocketContainer origContainer = ContainerProvider
				.getWebSocketContainer();
		TCKContainerProvider.setOriginalContainer(origContainer);

		String name = null;

		name = AccessController.doPrivileged(new PrivilegedAction<String>() {
			@Override
			public String run() {
				String name = null;
				ClassLoader origCl = Thread.currentThread()
						.getContextClassLoader();
				try {
					TCKClassLoader myCl = new TCKClassLoader(origCl);
					Thread.currentThread().setContextClassLoader(myCl);

					WebSocketContainer container = ContainerProvider
							.getWebSocketContainer();

					if (TCKWebSocketContainer.class.isInstance(container))
						name = TCKWebSocketContainer.class.getName();
					else
						name = container.getClass().getName();
				} finally {
					Thread.currentThread().setContextClassLoader(origCl);
				}
				return name;
			}
		});
		return name;
	}

}
