/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSTextStreamDecoderAndSessionClientEndpoint.java 72761 2013-08-30 17:06:49Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpointonmessage;

import java.io.IOException;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanClientEndpoint;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamDecoder;

@ClientEndpoint(decoders = { StringBeanTextStreamDecoder.class })
public class WSTextStreamDecoderAndSessionClientEndpoint extends
		AnnotatedClientEndpoint<StringBean> {

	public WSTextStreamDecoderAndSessionClientEndpoint() {
		super(new StringBeanClientEndpoint());
	}

	@OnMessage
	public void echo(Session s, StringBean bean) throws IOException {
		super.onMessage(bean);
		s.getBasicRemote().sendText(bean.get());
	}

	@OnError
	@Override
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

	@OnClose
	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnOpen
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}
}
