/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.idstore.multiauthz;

import static javax.security.enterprise.identitystore.CredentialValidationResult.INVALID_RESULT;
import static javax.security.enterprise.identitystore.CredentialValidationResult.NOT_VALIDATED_RESULT;
import static javax.security.enterprise.identitystore.IdentityStore.ValidationType.PROVIDE_GROUPS;
import static javax.security.enterprise.identitystore.IdentityStore.ValidationType.VALIDATE;
import static java.util.Arrays.asList;

import java.util.HashMap;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.ArrayList;

import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStore.ValidationType;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.CallerPrincipal;


/*
 * 
 */
@RequestScoped
public class IdentityStoreAuthz2 implements IdentityStore {

	
	private Map<String, Set<String>> userGroup;
	
	@PostConstruct
	public void init() {
		
		userGroup = new HashMap<>();
		userGroup.put("tom",new HashSet<>(asList( "AdminAuthz2", "ManagerAuthz2" )));
		userGroup.put("emma",new HashSet<>(asList( "AdminAuthz2", "EmployeeAuthz2")));
		userGroup.put("bob", new HashSet<>(asList( "AdminAuthz2")));
		
	}
	

	@Override
	public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
		System.out.println("IDStoreAuthz2:getCallerGroups...");
		
		Set<String> groups = new HashSet<String>();		
		groups.add("IDStoreAuthz2:getCallerGroups");  
		groups.addAll(userGroup.get(validationResult.getCallerPrincipal().getName()));
	    return groups;
	}
	
	@Override
	public int priority(){
		int priority = 100;
		return priority;
	}
	
	
	@Override
	public Set<ValidationType> validationTypes() {
		return EnumSet.of(PROVIDE_GROUPS);
	}

}
