/*
 * Copyright (c) 2017, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.sun.ts.tests.securityapi.idstore.idstorepermission;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.securityapi.idstore.common.BaseIDStoreClient;
import com.sun.ts.tests.common.webclient.http.HttpRequest;

import java.io.PrintWriter;
import java.util.Properties;

public class Client extends BaseIDStoreClient {

    private String pageServletBase = "/securityapi_idstore_idstorepermission_web";
    
    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, new PrintWriter(System.out), 
                   new PrintWriter(System.err));
        s.exit();
    }


    /**
     * Entry point for same-VM execution. In different-VM execution, the 
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        Client theTests = new Client();

        return super.run(args, out, err);
    }

    /*
     *   @class.setup_props: webServerHost;
     *                       webServerPort;
     *                       ts_home;
     *
     *
     */
    //Note:Based on the input argument setup will intialize JSP or servlet pages

    public void setup(String[] args, Properties p) throws Fault {
        super.setup(args, p);
        
        props = p;
    }

    /*
     * @testName:  testIdentityStore_customHandlerWithoutIDStorePermission
     *
     * @assertion_ids: Security:SPEC:3.2.2-3
     *
     * @test_Strategy:
     * 
     * Test the custom idstoreHandler is not granted with IdentityStorePermission
     * Then Exception is thrown in server since handler can't access to getGroup() method
     */
    public void testIdentityStore_customHandlerWithoutIDStorePermission() throws Fault {
    	String testName = "idstore/idstorepermission/testIdentityStore_customHandlerWithoutIDStorePermission";
    	String pageSec = pageServletBase + "/ServletForIDStoreCustomhandler";    	
		String username = "tom";
    	String password = "secret1";    	
    	
    	String url = pageSec + "?user=" + username;
    	url += "&pwd=" + password;    	

        StringBuffer sb = new StringBuffer(100);        
        sb.append("Exception received.").append("|");
        
        TEST_PROPS.setProperty(TEST_NAME, testName);
        TEST_PROPS.setProperty(REQUEST, getRequestLine("GET", url));
        TEST_PROPS.setProperty(SEARCH_STRING, sb.toString());
        invoke();
        dumpResponse();        
    }   
    

}

